/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.foundation;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.UTFDataFormatException;
import org.prevayler.foundation.Chunk;
import org.prevayler.foundation.Chunking;
import org.prevayler.foundation.monitor.Monitor;

public class DurableInputStream {
    private final File _file;
    private boolean _EOF = false;
    private Monitor _monitor;
    private InputStream _fileStream;

    public DurableInputStream(File file, Monitor monitor) throws IOException {
        this._monitor = monitor;
        this._file = file;
        this._fileStream = new BufferedInputStream(new FileInputStream(file));
    }

    public Chunk readChunk() throws IOException {
        if (this._EOF) {
            throw new EOFException();
        }
        try {
            Chunk chunk = Chunking.readChunk(this._fileStream);
            if (chunk != null) {
                return chunk;
            }
        }
        catch (EOFException eofx) {
        }
        catch (ObjectStreamException scx) {
            this.ignoreStreamCorruption(scx);
        }
        catch (UTFDataFormatException utfx) {
            this.ignoreStreamCorruption(utfx);
        }
        catch (RuntimeException rx) {
            this.ignoreStreamCorruption(rx);
        }
        this._fileStream.close();
        this._EOF = true;
        throw new EOFException();
    }

    private void ignoreStreamCorruption(Exception ex) {
        String message = "Stream corruption found while reading a transaction from the journal. If this is a transaction that was being written when a system crash occurred, there is no problem because it was never executed on the Prevalent System. Before executing each transaction, Prevayler writes it to the journal and calls the java.io.FileDescritor.sync() method to instruct the Java API to physically sync all operating system RAM buffers to disk.";
        this._monitor.notify(this.getClass(), message, this._file, ex);
    }

    public void close() throws IOException {
        this._fileStream.close();
        this._EOF = true;
    }
}

