/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.URIish;

public final class GoogleCloudSourceSupport {
    boolean canHandle(String uri) {
        try {
            return GCSTransportConfigCallback.canHandle(new URIish(uri));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    TransportConfigCallback createTransportConfigCallback() {
        return new GCSTransportConfigCallback(new ApplicationDefaultCredentialsProvider());
    }

    TransportConfigCallback createTransportConfigCallback(CredentialsProvider credentialsProvider) {
        return new GCSTransportConfigCallback(credentialsProvider);
    }

    private static final class GCSTransportConfigCallback
    implements TransportConfigCallback {
        private static final String GOOGLE_CLOUD_SOURCE_HOST = "source.developers.google.com";
        private final CredentialsProvider credentialsProvider;

        private GCSTransportConfigCallback(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
        }

        public void configure(Transport transport) {
            if (transport instanceof TransportHttp && GCSTransportConfigCallback.canHandle(transport.getURI())) {
                this.addHeaders((TransportHttp)transport, this.credentialsProvider.getAuthorizationHeaders());
            }
        }

        private static boolean canHandle(URIish uri) {
            return GCSTransportConfigCallback.isHttpScheme(uri) && GCSTransportConfigCallback.isGoogleCloudSourceHost(uri);
        }

        private static boolean isHttpScheme(URIish uri) {
            String scheme = uri.getScheme();
            return Objects.equals(scheme, "http") || Objects.equals(scheme, "https");
        }

        private static boolean isGoogleCloudSourceHost(URIish uri) {
            return Objects.equals(uri.getHost(), GOOGLE_CLOUD_SOURCE_HOST);
        }

        private void addHeaders(TransportHttp transport, Map<String, String> headers) {
            transport.setAdditionalHeaders(headers);
        }
    }

    private static class ApplicationDefaultCredentialsProvider
    implements CredentialsProvider {
        private ApplicationDefaultCredentialsProvider() {
        }

        @Override
        public Map<String, String> getAuthorizationHeaders() {
            try {
                return GoogleCredentials.getApplicationDefault().getRequestMetadata().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::joinValues));
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private String joinValues(Map.Entry<?, List<String>> entry) {
            return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue());
        }
    }

    static interface CredentialsProvider {
        public Map<String, String> getAuthorizationHeaders();
    }
}

