/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TransportMappings {
    private static final LogAdapter logger = LogFactory.getLogger(TransportMappings.class);
    public static final String TRANSPORT_MAPPINGS = "org.snmp4j.transportMappings";
    private static final String TRANSPORT_MAPPINGS_DEFAULT = "transports.properties";
    private static TransportMappings instance = null;
    private Hashtable transportMappings = null;

    protected TransportMappings() {
    }

    public static TransportMappings getInstance() {
        if (instance == null) {
            instance = new TransportMappings();
        }
        return instance;
    }

    public TransportMapping createTransportMapping(Address address) {
        Class clazz;
        if (this.transportMappings == null) {
            this.registerTransportMappings();
        }
        if ((clazz = (Class)this.transportMappings.get(address.getClass().getName())) == null) {
            return null;
        }
        Class[] classArray = new Class[]{address.getClass()};
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
            return (TransportMapping)constructor.newInstance(address);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (logger.isDebugEnabled()) {
                invocationTargetException.printStackTrace();
            }
            logger.error(invocationTargetException);
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                exception.printStackTrace();
            }
            logger.error(exception);
            return null;
        }
    }

    protected synchronized void registerTransportMappings() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String string;
            InputStream inputStream = TransportMappings.class.getResourceAsStream(string = System.getProperty(TRANSPORT_MAPPINGS, TRANSPORT_MAPPINGS_DEFAULT));
            if (inputStream == null) {
                throw new InternalError("Could not read '" + string + "' from classpath!");
            }
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                Hashtable hashtable = new Hashtable(properties.size());
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    try {
                        Class<?> clazz = Class.forName(string3);
                        hashtable.put(string2, clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.error(classNotFoundException);
                    }
                }
                this.transportMappings = hashtable;
            }
            catch (IOException iOException) {
                String string4 = "Could not read '" + string + "': " + iOException.getMessage();
                logger.error(string4);
                throw new InternalError(string4);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn(iOException);
                }
            }
        }
        Hashtable<String, Class> hashtable = new Hashtable<String, Class>(2);
        hashtable.put("org.snmp4j.smi.UdpAddress", DefaultUdpTransportMapping.class);
        hashtable.put("org.snmp4j.smi.TcpAddress", DefaultTcpTransportMapping.class);
        this.transportMappings = hashtable;
    }
}

