/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.util.Assert;

final class ConfigServerInstanceMonitor
implements SmartApplicationListener {
    private final Log log;
    private final ConfigClientProperties config;
    private final ConfigServerInstanceProvider instanceProvider;
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private boolean refreshOnStartup = true;

    ConfigServerInstanceMonitor(Log log, ConfigClientProperties config, ConfigServerInstanceProvider instanceProvider) {
        this.log = log;
        this.config = config;
        this.instanceProvider = instanceProvider;
    }

    void setRefreshOnStartup(boolean refreshOnStartup) {
        this.refreshOnStartup = refreshOnStartup;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ContextRefreshedEvent.class.isAssignableFrom(eventType) || HeartbeatEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.startup((ContextRefreshedEvent)event);
        } else if (event instanceof HeartbeatEvent) {
            this.heartbeat((HeartbeatEvent)event);
        }
    }

    public void startup(ContextRefreshedEvent event) {
        if (this.refreshOnStartup) {
            this.refresh();
        }
    }

    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            this.refresh();
        }
    }

    void refresh() {
        block8: {
            try {
                String serviceId = this.config.getDiscovery().getServiceId();
                Assert.hasText((String)serviceId, () -> "spring.cloud.config.service-id may not be null or empty");
                ArrayList<String> listOfUrls = new ArrayList<String>();
                List<ServiceInstance> serviceInstances = this.instanceProvider.getConfigServerInstances(serviceId);
                for (int i = 0; i < serviceInstances.size(); ++i) {
                    ServiceInstance server = serviceInstances.get(i);
                    Object url = this.getHomePage(server);
                    if (server.getMetadata().containsKey("password")) {
                        String user = (String)server.getMetadata().get("user");
                        user = user == null ? "user" : user;
                        this.config.setUsername(user);
                        String password = (String)server.getMetadata().get("password");
                        this.config.setPassword(password);
                    }
                    if (server.getMetadata().containsKey("configPath")) {
                        String path = (String)server.getMetadata().get("configPath");
                        if (((String)url).endsWith("/") && path.startsWith("/")) {
                            url = ((String)url).substring(0, ((String)url).length() - 1);
                        }
                        url = (String)url + path;
                    }
                    listOfUrls.add((String)url);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Updating config uris to " + listOfUrls));
                }
                String[] uri = new String[listOfUrls.size()];
                uri = listOfUrls.toArray(uri);
                this.config.setUri(uri);
            }
            catch (Exception ex) {
                if (this.config.isFailFast()) {
                    throw ex;
                }
                if (!this.log.isWarnEnabled()) break block8;
                this.log.warn((Object)"Could not locate configserver via discovery", (Throwable)ex);
            }
        }
    }

    private String getHomePage(ServiceInstance server) {
        return server.getUri().toString() + "/";
    }
}

