/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyEnumerate$PyExposer;
import org.python.core.PyEnumerateDerived;
import org.python.core.PyIterator;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="enumerate", base=PyObject.class, doc="enumerate(iterable[, start]) -> iterator for index, value of iterable\n\nReturn an enumerate object.  iterable must be another object that supports\niteration.  The enumerate object yields pairs containing a count (from\nstart, which defaults to zero) and a value yielded by the iterable argument.\nenumerate is useful for obtaining an indexed list:\n    (0, seq[0]), (1, seq[1]), (2, seq[2]), ...")
public class PyEnumerate
extends PyIterator {
    public static final PyType TYPE;
    private PyObject index;
    private PyObject sit;

    public PyEnumerate(PyType subType) {
        super(subType);
    }

    public PyEnumerate(PyType subType, PyObject seq, PyObject start) {
        super(subType);
        this.index = start;
        this.sit = seq.__iter__();
    }

    public PyEnumerate(PyObject seq, PyObject start) {
        this(TYPE, seq, start);
    }

    @Override
    public PyObject next() {
        return this.enumerate_next();
    }

    final PyObject enumerate_next() {
        return this.doNext(this.enumerate___iternext__());
    }

    final PyObject enumerate___iter__() {
        return super.__iter__();
    }

    @ExposedNew
    public static final PyObject enumerate_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length > 2 || args.length <= 0) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(args.length, true, "enumerate", 1, 2);
        }
        ArgParser ap = new ArgParser("enumerate", args, keywords, new String[]{"sequence", "start"});
        PyObject seq = ap.getPyObject(0);
        PyObject start = ap.getPyObject(1, Py.newInteger(0));
        if (!start.isIndex()) {
            throw Py.TypeError("an integer is required");
        }
        if (new_.for_type == subtype) {
            return new PyEnumerate(seq, start);
        }
        return new PyEnumerateDerived(subtype, seq, start);
    }

    @Override
    public PyObject __iternext__() {
        return this.enumerate___iternext__();
    }

    final PyObject enumerate___iternext__() {
        PyObject nextItem = this.sit.__iternext__();
        if (nextItem == null) {
            if (this.sit instanceof PyIterator && ((PyIterator)this.sit).stopException != null) {
                this.stopException = ((PyIterator)this.sit).stopException;
            }
            return null;
        }
        PyTuple next = new PyTuple(this.index, nextItem);
        this.index = this.index.__radd__(Py.newInteger(1));
        return next;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retValue = super.traverse(visit, arg);
        if (retValue != 0) {
            return retValue;
        }
        if (this.index != null && (retValue = visit.visit(this.index, arg)) != 0) {
            return retValue;
        }
        return this.sit == null ? 0 : visit.visit(this.sit, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.index || ob == this.sit || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(PyEnumerate.class, new PyEnumerate$PyExposer());
        TYPE = PyType.fromClass(PyEnumerate.class);
    }
}

