/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public enum FilePermission {
    USR_R(256),
    USR_W(128),
    USR_X(64),
    GRP_R(32),
    GRP_W(16),
    GRP_X(8),
    OTH_R(4),
    OTH_W(2),
    OTH_X(1),
    SUID(2048),
    SGID(1024),
    STICKY(512),
    USR_RWX(USR_R, USR_W, USR_X),
    GRP_RWX(GRP_R, GRP_W, GRP_X),
    OTH_RWX(OTH_R, OTH_W, OTH_X);

    private final int val;

    private FilePermission(int val) {
        this.val = val;
    }

    private FilePermission(FilePermission ... perms) {
        int val = 0;
        for (FilePermission perm : perms) {
            val |= perm.val;
        }
        this.val = val;
    }

    public boolean isIn(int mask) {
        return (mask & this.val) == this.val;
    }

    public static Set<FilePermission> fromMask(int mask) {
        LinkedList<FilePermission> perms = new LinkedList<FilePermission>();
        for (FilePermission p : FilePermission.values()) {
            if (!p.isIn(mask)) continue;
            perms.add(p);
        }
        return new HashSet<FilePermission>(perms);
    }

    public static int toMask(Set<FilePermission> perms) {
        int mask = 0;
        for (FilePermission p : perms) {
            mask |= p.val;
        }
        return mask;
    }
}

