/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yacron4j;

import io.nettyx.util.Timeout;
import io.nettyx.util.Timer;
import io.nettyx.util.TimerTask;
import io.nettyx.util.internal.logging.InternalLogger;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.quartzx.CronExpression;
import org.rzo.yacron4j.TaskOptions;
import org.rzo.yacron4j.persist.PersistManager;

public class CronTaskImpl
implements ScheduledFuture {
    final Timer _timer;
    final CronExpression _exp;
    final AtomicLong _scheduledExecutionTime = new AtomicLong();
    final AtomicBoolean _terminated = new AtomicBoolean(false);
    final TimerTask _task;
    final AtomicReference<Timeout> _timeout = new AtomicReference();
    final TaskOptions _options;
    final AtomicInteger _concurrentExecs = new AtomicInteger(0);
    final CopyOnWriteArrayList<Thread> _executors = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<Object> _results = new CopyOnWriteArrayList();
    final InternalLogger _logger;
    final AtomicBoolean _canceled = new AtomicBoolean(false);
    final Lock _lock = new ReentrantLock();
    final Condition _resultReady = this._lock.newCondition();
    final AtomicReference<Date> _next = new AtomicReference();
    final String _id;
    final boolean _debug;
    final PersistManager _persistManager;
    final boolean _persist;

    protected CronTaskImpl(String id, Timer timer, CronExpression exp, Runnable task, TaskOptions options, PersistManager persistManager) {
        this._id = id;
        this._persist = options.isPersist() && !this._id.startsWith("noname-");
        this._persistManager = persistManager;
        this._debug = options.isDebug();
        this._exp = exp;
        this._timer = timer;
        this._scheduledExecutionTime.set(this._exp.getTimeAfter(new Date()).getTime());
        this._options = options;
        this._logger = options.getLogger();
        this._task = new CronTimerTask(task);
    }

    protected CronTaskImpl(String id, Timer timer, CronExpression exp, Callable task, TaskOptions options, PersistManager persistManager) {
        this._id = id;
        this._persist = options.isPersist() && !this._id.startsWith("noname-");
        this._persistManager = persistManager;
        this._debug = options.isDebug();
        this._exp = exp;
        this._timer = timer;
        this._options = options;
        this._logger = options.getLogger();
        this._task = new CronTimerTask(task);
    }

    protected boolean start() {
        Date date = this._exp.getTimeAfter(new Date());
        if (date == null) {
            this._terminated.set(true);
            this._logger.warn(String.valueOf(this._id) + ": no next task execution -> ignore");
            return false;
        }
        Long persistedSchedule = this._persistManager.getSchedule(this._id);
        if (persistedSchedule != null) {
            this._scheduledExecutionTime.set(persistedSchedule);
        } else {
            this._scheduledExecutionTime.set(date.getTime());
        }
        return this.scheduleNextExecution();
    }

    private synchronized boolean scheduleNextExecution() {
        if (this._terminated.get()) {
            return false;
        }
        this.persistSchedule(this._scheduledExecutionTime.get());
        if (this._debug) {
            this._logger.info(String.valueOf(this._id) + ": scheduled next execution: " + new Date(this._scheduledExecutionTime.get()));
        }
        this._next.set(this._exp.getTimeAfter(new Date(this._scheduledExecutionTime.get())));
        long delay = this._scheduledExecutionTime.get() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        if (!this._timer.isStarted()) {
            return false;
        }
        this._timeout.set(this._timer.newTimeout(this._task, delay - 10L, TimeUnit.MILLISECONDS));
        return true;
    }

    public long getDelay(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this._scheduledExecutionTime.get() - System.currentTimeMillis(), timeUnit);
    }

    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this._debug) {
            this._logger.info(String.valueOf(this._id) + ": cancel");
        }
        this.persistTerminated();
        this._canceled.set(true);
        this._terminated.set(true);
        if (this._timeout != null) {
            return this._timeout.get().cancel();
        }
        if (mayInterruptIfRunning) {
            for (Thread thread : this._executors) {
                thread.interrupt();
            }
        }
        return true;
    }

    private void persistTerminated() {
        if (this._persist) {
            this._persistManager.terminated(this._id);
        }
    }

    private void persistSchedule(long schedule) {
        if (this._persist) {
            this._persistManager.scheduled(this._id, schedule);
        }
    }

    public int compareTo(Delayed o) {
        long result = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
        if (result > 0L) {
            return 1;
        }
        if (result < 0L) {
            return -1;
        }
        return 0;
    }

    public boolean isCancelled() {
        return this._canceled.get();
    }

    public boolean isDone() {
        return this._terminated.get();
    }

    public Object get() throws InterruptedException, ExecutionException {
        if (this._canceled.get()) {
            throw new RuntimeException(String.valueOf(this._id) + " task cancelled");
        }
        if (this._terminated.get()) {
            return this.getResult();
        }
        if (this._results.size() > 0) {
            return this.getResult();
        }
        this._lock.lock();
        try {
            this._resultReady.await();
        }
        finally {
            this._lock.unlock();
        }
        return this.getResult();
    }

    private synchronized Object getResult() {
        if (this._canceled.get()) {
            throw new RuntimeException(String.valueOf(this._id) + " task cancelled");
        }
        if (this._results.size() == 0) {
            return null;
        }
        return this._results.remove(0);
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this._canceled.get()) {
            throw new RuntimeException(String.valueOf(this._id) + " task cancelled");
        }
        if (this._terminated.get()) {
            return this.getResult();
        }
        if (this._results.size() > 0) {
            return this.getResult();
        }
        this._lock.lock();
        try {
            this._resultReady.await(timeout, unit);
        }
        finally {
            this._lock.unlock();
        }
        return this.getResult();
    }

    private void terminate() {
        if (this._debug) {
            this._logger.info(String.valueOf(this._id) + ": terminated");
        }
        this.persistTerminated();
        this._terminated.set(true);
        this._timeout.set(null);
        this._scheduledExecutionTime.set(-1L);
        this._lock.lock();
        this._resultReady.signal();
        this._lock.unlock();
    }

    class CronTimerTask
    implements TimerTask {
        protected final Runnable _runnable;
        protected final Callable _callable;

        public CronTimerTask(Runnable task) {
            this._runnable = task;
            this._callable = null;
        }

        public CronTimerTask(Callable task) {
            this._callable = task;
            this._runnable = null;
        }

        private void runTask() {
            while (true) {
                try {
                    CronTaskImpl.this._executors.add(Thread.currentThread());
                    if (CronTaskImpl.this._debug) {
                        CronTaskImpl.this._logger.info(String.valueOf(CronTaskImpl.this._id) + ": exec start");
                    }
                    if (this._runnable != null) {
                        this._runnable.run();
                    } else {
                        Object result = this._callable.call();
                        CronTaskImpl.this._results.add(result);
                    }
                    if (CronTaskImpl.this._debug) {
                        CronTaskImpl.this._logger.info(String.valueOf(CronTaskImpl.this._id) + ": exec end");
                    }
                    return;
                }
                catch (Throwable ex) {
                    if (ex instanceof InterruptedException) {
                        CronTaskImpl.this._logger.error(String.valueOf(CronTaskImpl.this._id) + ": task execution interrupted -> abort", ex);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    if (CronTaskImpl.this._options.getExceptionResolution() == TaskOptions.EXCEPTION_CANCEL) {
                        CronTaskImpl.this._logger.error(String.valueOf(CronTaskImpl.this._id) + " task execution error -> cancel", ex);
                        CronTaskImpl.this.cancel(false);
                        return;
                    }
                    if (CronTaskImpl.this._options.getExceptionResolution() == TaskOptions.EXCEPTION_IGNORE) {
                        CronTaskImpl.this._logger.error(String.valueOf(CronTaskImpl.this._id) + " task execution error -> ignore", ex);
                        return;
                    }
                    CronTaskImpl.this._logger.error(String.valueOf(CronTaskImpl.this._id) + " task execution error -> retry", ex);
                    continue;
                }
                finally {
                    CronTaskImpl.this._executors.remove(Thread.currentThread());
                    CronTaskImpl.this._lock.lock();
                    try {
                        CronTaskImpl.this._resultReady.signal();
                        continue;
                    }
                    finally {
                        CronTaskImpl.this._lock.unlock();
                        continue;
                    }
                }
                break;
            }
        }

        public void run(Timeout paramTimeout) throws Exception {
            boolean lastExecution;
            if (CronTaskImpl.this._terminated.get()) {
                return;
            }
            Date next = CronTaskImpl.this._next.get();
            boolean bl = lastExecution = next == null;
            if (lastExecution) {
                this.runTask();
                CronTaskImpl.this.terminate();
                return;
            }
            if (CronTaskImpl.this._options.isAllowOverlap()) {
                CronTaskImpl.this._scheduledExecutionTime.set(next.getTime());
                CronTaskImpl.this.scheduleNextExecution();
                if (CronTaskImpl.this._concurrentExecs.get() < CronTaskImpl.this._options.getMaxConcurrent()) {
                    CronTaskImpl.this._concurrentExecs.incrementAndGet();
                    this.runTask();
                    CronTaskImpl.this._concurrentExecs.decrementAndGet();
                } else {
                    CronTaskImpl.this._logger.warn(String.valueOf(CronTaskImpl.this._id) + ": too many concurrent tasks #" + CronTaskImpl.this._concurrentExecs.get());
                }
            } else if (CronTaskImpl.this._options.isIgnoreOnOverlap()) {
                this.runTask();
                CronTaskImpl.this._scheduledExecutionTime.set(next.getTime());
                if (CronTaskImpl.this._scheduledExecutionTime.get() < System.currentTimeMillis()) {
                    Date date = CronTaskImpl.this._exp.getTimeAfter(new Date());
                    if (date == null) {
                        CronTaskImpl.this.persistTerminated();
                        CronTaskImpl.this._terminated.set(true);
                        return;
                    }
                    CronTaskImpl.this._scheduledExecutionTime.set(date.getTime());
                }
                CronTaskImpl.this.scheduleNextExecution();
            } else {
                this.runTask();
                CronTaskImpl.this._scheduledExecutionTime.set(next.getTime());
                CronTaskImpl.this.scheduleNextExecution();
            }
        }
    }
}

