/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite.reactive;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.commons.publisher.CloudFlux;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import reactor.core.publisher.Flux;

public class ReactiveCompositeDiscoveryClient
implements ReactiveDiscoveryClient {
    private final List<ReactiveDiscoveryClient> discoveryClients;

    public ReactiveCompositeDiscoveryClient(List<ReactiveDiscoveryClient> discoveryClients) {
        AnnotationAwareOrderComparator.sort(discoveryClients);
        this.discoveryClients = discoveryClients;
    }

    @Override
    public String description() {
        return "Composite Reactive Discovery Client";
    }

    @Override
    public Flux<ServiceInstance> getInstances(String serviceId) {
        if (this.discoveryClients == null || this.discoveryClients.isEmpty()) {
            return Flux.empty();
        }
        ArrayList<Flux<ServiceInstance>> serviceInstances = new ArrayList<Flux<ServiceInstance>>();
        for (ReactiveDiscoveryClient discoveryClient : this.discoveryClients) {
            serviceInstances.add(discoveryClient.getInstances(serviceId));
        }
        return CloudFlux.firstNonEmpty(serviceInstances);
    }

    @Override
    public Flux<String> getServices() {
        if (this.discoveryClients == null || this.discoveryClients.isEmpty()) {
            return Flux.empty();
        }
        return Flux.fromIterable(this.discoveryClients).flatMap(ReactiveDiscoveryClient::getServices);
    }

    public List<ReactiveDiscoveryClient> getDiscoveryClients() {
        return this.discoveryClients;
    }
}

