/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnBootstrapDisabledCondition.class})
public @interface ConditionalOnBootstrapDisabled {

    public static class OnBootstrapDisabledCondition
    extends NoneNestedConditions {
        OnBootstrapDisabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"spring.cloud.bootstrap.enabled"})
        static class OnBootstrapEnabled {
            OnBootstrapEnabled() {
            }
        }

        @ConditionalOnProperty(name={"spring.config.use-legacy-processing"})
        static class OnUseLegacyProcessingEnabled {
            OnUseLegacyProcessingEnabled() {
            }
        }

        @ConditionalOnClass(name={"org.springframework.cloud.bootstrap.marker.Marker"})
        static class OnBootstrapMarkerClassPresent {
            OnBootstrapMarkerClassPresent() {
            }
        }
    }
}

