/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.colors;

import com.jeta.forms.components.colors.ColorChooserFactory;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JETAColorWell
extends JComponent {
    private Color m_color;
    private LinkedList m_listeners;

    public JETAColorWell() {
        this.initialize(null);
    }

    public JETAColorWell(Color color) {
        this.initialize(color);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList();
        }
        if (!this.m_listeners.contains(actionListener)) {
            this.m_listeners.add(actionListener);
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    protected void initialize(Color color) {
        this.m_color = color == null ? Color.black : color;
        this.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dimension = new Dimension(16, 16);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.addMouseListener(new ColorWellListener());
    }

    protected void notifyListeners(ActionEvent actionEvent) {
        if (this.m_listeners != null) {
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.getColor());
        Rectangle rectangle = graphics.getClipBounds();
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(actionListener);
        }
    }

    public void setColor(Color color) {
        this.m_color = color;
        this.repaint();
    }

    public class ColorWellListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            JETAColorWell jETAColorWell = (JETAColorWell)mouseEvent.getSource();
            Color color = null;
            ColorChooserFactory colorChooserFactory = (ColorChooserFactory)JETARegistry.lookup("color.chooser.factory");
            color = colorChooserFactory != null ? colorChooserFactory.showColorChooser(jETAColorWell, I18N.getLocalizedMessage("Color Chooser"), jETAColorWell.getColor()) : JColorChooser.showDialog(SwingUtilities.getWindowAncestor(jETAColorWell), I18N.getLocalizedMessage("Color Chooser"), jETAColorWell.getColor());
            if (color != null) {
                jETAColorWell.setColor(color);
                jETAColorWell.notifyListeners(new ActionEvent(JETAColorWell.this, 1001, jETAColorWell.getName()));
            }
        }
    }
}

