/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.client.oidc.authentication.logout.LogoutTokenClaimAccessor;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

final class OidcBackChannelLogoutTokenValidator
implements OAuth2TokenValidator<Jwt> {
    private static final String LOGOUT_VALIDATION_URL = "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation";
    private static final String BACK_CHANNEL_LOGOUT_EVENT = "http://schemas.openid.net/event/backchannel-logout";
    private final String audience;
    private final String issuer;

    OidcBackChannelLogoutTokenValidator(ClientRegistration clientRegistration) {
        this.audience = clientRegistration.getClientId();
        this.issuer = clientRegistration.getProviderDetails().getIssuerUri();
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        String jwtId;
        ArrayList<OAuth2Error> errors = new ArrayList<OAuth2Error>();
        LogoutTokenClaimAccessor logoutClaims = () -> ((Jwt)jwt).getClaims();
        Map events = logoutClaims.getEvents();
        if (events == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("events claim must not be null"));
        } else if (events.get(BACK_CHANNEL_LOGOUT_EVENT) == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("events claim map must contain \"http://schemas.openid.net/event/backchannel-logout\" key"));
        }
        String issuer = logoutClaims.getIssuer().toExternalForm();
        if (issuer == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("iss claim must not be null"));
        } else if (!this.issuer.equals(issuer)) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("iss claim value must match `ClientRegistration#getProviderDetails#getIssuerUri`"));
        }
        List audience = logoutClaims.getAudience();
        if (audience == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("aud claim must not be null"));
        } else if (!audience.contains(this.audience)) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("aud claim value must include `ClientRegistration#getClientId`"));
        }
        Instant issuedAt = logoutClaims.getIssuedAt();
        if (issuedAt == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("iat claim must not be null"));
        }
        if ((jwtId = logoutClaims.getId()) == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("jti claim must not be null"));
        }
        if (logoutClaims.getSubject() == null && logoutClaims.getSessionId() == null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("sub and sid claims must not both be null"));
        }
        if (logoutClaims.getClaim("nonce") != null) {
            errors.add(OidcBackChannelLogoutTokenValidator.invalidLogoutToken("nonce claim must not be present"));
        }
        return OAuth2TokenValidatorResult.failure(errors);
    }

    private static OAuth2Error invalidLogoutToken(String description) {
        return new OAuth2Error("invalid_token", description, LOGOUT_VALIDATION_URL);
    }
}

