/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AdviceModeImportSelector;
import org.springframework.context.annotation.AutoProxyRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.MethodSecurityAdvisorRegistrar;
import org.springframework.security.config.annotation.method.configuration.ReactiveAuthorizationManagerMethodSecurityConfiguration;
import org.springframework.security.config.annotation.method.configuration.ReactiveAuthorizationProxyConfiguration;
import org.springframework.security.config.annotation.method.configuration.ReactiveMethodSecurityConfiguration;

class ReactiveMethodSecuritySelector
implements ImportSelector {
    private final ImportSelector autoProxy = new AutoProxyRegistrarSelector();

    ReactiveMethodSecuritySelector() {
    }

    public String[] selectImports(AnnotationMetadata importMetadata) {
        if (!importMetadata.hasAnnotation(EnableReactiveMethodSecurity.class.getName())) {
            return new String[0];
        }
        EnableReactiveMethodSecurity annotation = (EnableReactiveMethodSecurity)importMetadata.getAnnotations().get(EnableReactiveMethodSecurity.class).synthesize();
        ArrayList<String> imports = new ArrayList<String>(Arrays.asList(this.autoProxy.selectImports(importMetadata)));
        if (annotation.useAuthorizationManager()) {
            imports.add(ReactiveAuthorizationManagerMethodSecurityConfiguration.class.getName());
        } else {
            imports.add(ReactiveMethodSecurityConfiguration.class.getName());
        }
        imports.add(ReactiveAuthorizationProxyConfiguration.class.getName());
        return imports.toArray(new String[0]);
    }

    private static final class AutoProxyRegistrarSelector
    extends AdviceModeImportSelector<EnableReactiveMethodSecurity> {
        private static final String[] IMPORTS = new String[]{AutoProxyRegistrar.class.getName(), MethodSecurityAdvisorRegistrar.class.getName()};

        private AutoProxyRegistrarSelector() {
        }

        protected String[] selectImports(@NonNull AdviceMode adviceMode) {
            if (adviceMode == AdviceMode.PROXY) {
                return IMPORTS;
            }
            throw new IllegalStateException("AdviceMode " + adviceMode + " is not supported");
        }
    }
}

