/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

class OidcBackChannelLogoutFilter
extends OncePerRequestFilter {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final AuthenticationConverter authenticationConverter;
    private final AuthenticationManager authenticationManager;
    private final OAuth2ErrorHttpMessageConverter errorHttpMessageConverter = new OAuth2ErrorHttpMessageConverter();
    private LogoutHandler logoutHandler = new OidcBackChannelLogoutHandler();

    OidcBackChannelLogoutFilter(AuthenticationConverter authenticationConverter, AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationConverter = authenticationConverter;
        this.authenticationManager = authenticationManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Authentication authentication;
        Authentication token;
        try {
            token = this.authenticationConverter.convert(request);
        }
        catch (AuthenticationServiceException ex) {
            this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout", (Throwable)ex);
            throw ex;
        }
        catch (AuthenticationException ex) {
            this.handleAuthenticationFailure(response, (Exception)((Object)ex));
            return;
        }
        if (token == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            authentication = this.authenticationManager.authenticate(token);
        }
        catch (AuthenticationServiceException ex) {
            this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout", (Throwable)ex);
            throw ex;
        }
        catch (AuthenticationException ex) {
            this.handleAuthenticationFailure(response, (Exception)((Object)ex));
            return;
        }
        this.logoutHandler.logout(request, response, authentication);
    }

    private void handleAuthenticationFailure(HttpServletResponse response, Exception ex) throws IOException {
        this.logger.debug((Object)"Failed to process OIDC Back-Channel Logout", (Throwable)ex);
        response.setStatus(400);
        this.errorHttpMessageConverter.write((Object)this.oauth2Error(ex), null, (HttpOutputMessage)new ServletServerHttpResponse(response));
    }

    private OAuth2Error oauth2Error(Exception ex) {
        if (ex instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException oauth2 = (OAuth2AuthenticationException)ex;
            return oauth2.getError();
        }
        return new OAuth2Error("invalid_request", ex.getMessage(), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
    }

    void setLogoutHandler(LogoutHandler logoutHandler) {
        Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
        this.logoutHandler = logoutHandler;
    }
}

