/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.util.Random;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameError;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventOrError;
import org.apache.pekko.http.impl.engine.ws.FrameEventParser$;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.Masking$;
import org.apache.pekko.http.impl.engine.ws.Masking$Masker$;
import org.apache.pekko.http.impl.engine.ws.Protocol;
import org.apache.pekko.http.impl.engine.ws.ProtocolException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]uAB\u000f\u001f\u0011\u0003!CF\u0002\u0004/=!\u0005Ae\f\u0005\u0006m\u0005!\t\u0001\u000f\u0005\u0006s\u0005!\tA\u000f\u0005\u0006?\u0006!\t\u0001\u0019\u0005\u0006O\u0006!\t\u0001\u001b\u0004\u0005]\u000511\u000eC\u0005\u0002H\u0019\u0011\t\u0011)A\u0005/\"1aG\u0002C\u0001\u0003\u0013Baa\u001f\u0004\u0005\u0002\u0005=\u0003bBA\u0006\r\u0011\u0005\u00111\u000b\u0005\b\u000332A\u0011IA.\u000f\u001d\t\u0019(\u0001E\u0005\u0003k2q!a\u001e\u0002\u0011\u0013\tI\b\u0003\u00047\u001b\u0011\u0005\u00111\u0010\u0005\u0007w6!\t!! \t\u000f\u0005-Q\u0002\"\u0001\u0002\u0002\"9\u0011\u0011L\u0007\u0005B\u0005mc!\u00028\u0002\u0003\u0013y\u0007\"\u0002\u001c\u0013\t\u0003Q\b\"B>\u0013\r\u0003a\bbBA\u0006%\u0019\u0005\u0011Q\u0002\u0005\n\u0003+\u0011\"\u0019!C\u0001\u0003/A\u0001\"a\b\u0013A\u0003%\u0011\u0011\u0004\u0005\n\u0003C\u0011\"\u0019!C\u0001\u0003GA\u0001\"a\u000b\u0013A\u0003%\u0011Q\u0005\u0005\n\u0003[\u0011\"\u0019!C!\u0003_Aq!!\r\u0013A\u0003%a\u000fC\u0004\u00024I!\t%!\u000e\u0002\u000f5\u000b7o[5oO*\u0011q\u0004I\u0001\u0003oNT!!\t\u0012\u0002\r\u0015tw-\u001b8f\u0015\t\u0019C%\u0001\u0003j[Bd'BA\u0013'\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dB\u0013!\u00029fW.|'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u0004\"!L\u0001\u000e\u0003y\u0011q!T1tW&twm\u0005\u0002\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002Y\u0005)\u0011\r\u001d9msR\u00191(\u0014*\u0011\u000fq\n5IR\"D\u00136\tQH\u0003\u0002?\u007f\u0005A1oY1mC\u0012\u001cHN\u0003\u0002AM\u000511\u000f\u001e:fC6L!AQ\u001f\u0003\u0011\tKG-\u001b$m_^\u0004\"!\f#\n\u0005\u0015s\"A\u0003$sC6,WI^3oiB\u0011QfR\u0005\u0003\u0011z\u0011\u0011C\u0012:b[\u0016,e/\u001a8u\u001fJ,%O]8s!\tQ5*D\u0001'\u0013\taeEA\u0004O_R,6/\u001a3\t\u000b9\u001b\u0001\u0019A(\u0002\u0015M,'O^3s'&$W\r\u0005\u00022!&\u0011\u0011K\r\u0002\b\u0005>|G.Z1o\u0011\u0015\u00196\u00011\u0001U\u0003)i\u0017m]6SC:$w.\u001c\t\u0004cU;\u0016B\u0001,3\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!Q\u000f^5m\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\rI\u000bg\u000eZ8n\u0003\u0019i\u0017m]6JMR\u0019\u0011\r\u001a4\u0011\u000bq\u00127iQ%\n\u0005\rl$\u0001\u0002$m_^DQ!\u001a\u0003A\u0002=\u000b\u0011bY8oI&$\u0018n\u001c8\t\u000bM#\u0001\u0019\u0001+\u0002\u0011UtW.Y:l\u0013\u001a$\"!\u001b6\u0011\u000bq\u00127IR%\t\u000b\u0015,\u0001\u0019A(\u0014\u0005\u0019a\u0007CA7\u0013\u001b\u0005\t!AB'bg.,'o\u0005\u0002\u0013aB\u0019\u0011\u000f\u001e<\u000e\u0003IT!a] \u0002\u000bM$\u0018mZ3\n\u0005U\u0014(AC$sCBD7\u000b^1hKB!q\u000f_\"G\u001b\u0005y\u0014BA=@\u0005%1En\\<TQ\u0006\u0004X\rF\u0001m\u0003-)\u0007\u0010\u001e:bGRl\u0015m]6\u0015\u0007u\f\t\u0001\u0005\u00022}&\u0011qP\r\u0002\u0004\u0013:$\bbBA\u0002)\u0001\u0007\u0011QA\u0001\u0007Q\u0016\fG-\u001a:\u0011\u00075\n9!C\u0002\u0002\ny\u00111B\u0012:b[\u0016DU-\u00193fe\u0006Q1/\u001a;OK^l\u0015m]6\u0015\r\u0005\u0015\u0011qBA\t\u0011\u001d\t\u0019!\u0006a\u0001\u0003\u000bAa!a\u0005\u0016\u0001\u0004i\u0018\u0001B7bg.\f!!\u001b8\u0016\u0005\u0005e\u0001\u0003B<\u0002\u001c\rK1!!\b@\u0005\u0015Ie\u000e\\3u\u0003\rIg\u000eI\u0001\u0004_V$XCAA\u0013!\u00119\u0018q\u0005$\n\u0007\u0005%rH\u0001\u0004PkRdW\r^\u0001\u0005_V$\b%A\u0003tQ\u0006\u0004X-F\u0001w\u0003\u0019\u0019\b.\u00199fA\u0005Y1M]3bi\u0016dunZ5d)\u0011\t9$!\u0010\u0011\u0007E\fI$C\u0002\u0002<I\u0014qb\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\u0005\b\u0003\u007fa\u0002\u0019AA!\u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t!\r9\u00181I\u0005\u0004\u0003\u000bz$AC!uiJL'-\u001e;fg\u00061!/\u00198e_6$B!a\u0013\u0002NA\u0011QN\u0002\u0005\u0007\u0003\u000fB\u0001\u0019A,\u0015\u0007u\f\t\u0006C\u0004\u0002\u0004%\u0001\r!!\u0002\u0015\r\u0005\u0015\u0011QKA,\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u000bAa!a\u0005\u000b\u0001\u0004i\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0003\u0003BA0\u0003[rA!!\u0019\u0002jA\u0019\u00111\r\u001a\u000e\u0005\u0005\u0015$bAA4o\u00051AH]8pizJ1!a\u001b3\u0003\u0019\u0001&/\u001a3fM&!\u0011qNA9\u0005\u0019\u0019FO]5oO*\u0019\u00111\u000e\u001a\u0002\u0013UsW.Y:lS:<\u0007CA7\u000e\u0005%)f.\\1tW&twm\u0005\u0002\u000eYR\u0011\u0011Q\u000f\u000b\u0004{\u0006}\u0004bBA\u0002\u001f\u0001\u0007\u0011Q\u0001\u000b\u0007\u0003\u000b\t\u0019)!\"\t\u000f\u0005\r\u0001\u00031\u0001\u0002\u0006!1\u00111\u0003\tA\u0002uD3!AAE!\u0011\tY)!%\u000e\u0005\u00055%bAAHM\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eK\u0002\u0001\u0003\u0013\u0003")
@InternalApi
public final class Masking {
    public static Flow<FrameEvent, FrameEventOrError, NotUsed> unmaskIf(boolean condition) {
        return Masking$.MODULE$.unmaskIf(condition);
    }

    public static Flow<FrameEvent, FrameEvent, NotUsed> maskIf(boolean condition, Function0<Random> maskRandom) {
        return Masking$.MODULE$.maskIf(condition, maskRandom);
    }

    public static BidiFlow<FrameEvent, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> apply(boolean serverSide, Function0<Random> maskRandom) {
        return Masking$.MODULE$.apply(serverSide, maskRandom);
    }

    private static abstract class Masker
    extends GraphStage<FlowShape<FrameEvent, FrameEventOrError>> {
        private final Inlet<FrameEvent> in = Inlet$.MODULE$.apply(new StringBuilder(3).append(this.toString()).append("-in").toString());
        private final Outlet<FrameEventOrError> out = Outlet$.MODULE$.apply(new StringBuilder(4).append(this.toString()).append("-out").toString());
        private final FlowShape<FrameEvent, FrameEventOrError> shape = new FlowShape(this.in(), this.out());

        public abstract int extractMask(FrameHeader var1);

        public abstract FrameHeader setNewMask(FrameHeader var1, int var2);

        public Inlet<FrameEvent> in() {
            return this.in;
        }

        public Outlet<FrameEventOrError> out() {
            return this.out;
        }

        public FlowShape<FrameEvent, FrameEventOrError> shape() {
            return this.shape;
        }

        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new OutHandler(this){
                private final /* synthetic */ Masker $outer;

                public void onUpstreamFinish() throws Exception {
                    InHandler.onUpstreamFinish$((InHandler)this);
                }

                public void onUpstreamFailure(Throwable ex) throws Exception {
                    InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                }

                public void onDownstreamFinish() throws Exception {
                    OutHandler.onDownstreamFinish$((OutHandler)this);
                }

                public void onDownstreamFinish(Throwable cause) throws Exception {
                    OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                }

                public void onPush() {
                    FrameEvent frameEvent = (FrameEvent)this.grab(this.$outer.in());
                    if (frameEvent instanceof FrameStart) {
                        BoxedUnit boxedUnit;
                        FrameStart frameStart = (FrameStart)frameEvent;
                        FrameHeader header = frameStart.header();
                        ByteString data = frameStart.data();
                        try {
                            int mask = this.$outer.extractMask(header);
                            Tuple2<ByteString, Object> tuple2 = FrameEventParser$.MODULE$.mask(data, mask);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = (ByteString)tuple2._1();
                            int newMask = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)masked, (Object)BoxesRunTime.boxToInteger((int)newMask));
                            ByteString masked2 = (ByteString)tuple22._1();
                            int newMask2 = tuple22._2$mcI$sp();
                            if (!frameStart.lastPart()) {
                                this.setHandler(this.$outer.in(), this.runningHandler(newMask2, this));
                            }
                            this.push(this.$outer.out(), frameStart.copy(this.$outer.setNewMask(header, mask), masked2));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (ProtocolException p) {
                            this.setHandler(this.$outer.in(), this.doneHandler());
                            this.push(this.$outer.out(), new FrameError(p));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    if (frameEvent instanceof FrameData) {
                        this.fail(this.$outer.out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                        return;
                    }
                    throw new MatchError((Object)frameEvent);
                }

                private InHandler doneHandler() {
                    return new InHandler(this){
                        private final /* synthetic */ Masker$$anon$1 $outer;

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$((InHandler)this);
                        }

                        public void onUpstreamFailure(Throwable ex) throws Exception {
                            InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                        }

                        public void onPush() {
                            this.$outer.pull(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            InHandler.$init$((InHandler)this);
                        }
                    };
                }

                private InHandler runningHandler(int initialMask, InHandler nextState) {
                    return new InHandler(this, initialMask, nextState){
                        private int mask;
                        private final /* synthetic */ Masker$$anon$1 $outer;
                        private final InHandler nextState$1;

                        public void onUpstreamFinish() throws Exception {
                            InHandler.onUpstreamFinish$((InHandler)this);
                        }

                        public void onUpstreamFailure(Throwable ex) throws Exception {
                            InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                        }

                        private int mask() {
                            return this.mask;
                        }

                        private void mask_$eq(int x$1) {
                            this.mask = x$1;
                        }

                        public void onPush() {
                            Tuple2<ByteString, Object> tuple2;
                            FrameEvent part = (FrameEvent)this.$outer.grab(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in());
                            if (part.lastPart()) {
                                this.$outer.setHandler(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$$anon$$$outer().in(), this.nextState$1);
                            }
                            if ((tuple2 = FrameEventParser$.MODULE$.mask(part.data(), this.mask())) == null) {
                                throw new MatchError(tuple2);
                            }
                            ByteString masked = (ByteString)tuple2._1();
                            int newMask = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)masked, (Object)BoxesRunTime.boxToInteger((int)newMask));
                            ByteString masked2 = (ByteString)tuple22._1();
                            int newMask2 = tuple22._2$mcI$sp();
                            this.mask_$eq(newMask2);
                            this.$outer.push(this.$outer.org$apache$pekko$http$impl$engine$ws$Masking$Masker$$anon$$$outer().out(), part.withData(masked2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nextState$1 = nextState$1;
                            InHandler.$init$((InHandler)this);
                            this.mask = initialMask$1;
                        }
                    };
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public /* synthetic */ Masker org$apache$pekko$http$impl$engine$ws$Masking$Masker$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    OutHandler.$init$((OutHandler)this);
                    InHandler.$init$((InHandler)this);
                    this.setHandler($outer.in(), this);
                    this.setHandler($outer.out(), this);
                }
            };
        }
    }

    private static final class Masking
    extends Masker {
        private final Random random;

        @Override
        public int extractMask(FrameHeader header) {
            return this.random.nextInt();
        }

        @Override
        public FrameHeader setNewMask(FrameHeader header, int mask) {
            if (header.mask().isDefined()) {
                throw new ProtocolException("Frame mustn't already be masked");
            }
            Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)mask));
            Protocol.Opcode x$2 = header.copy$default$1();
            long x$3 = header.copy$default$3();
            boolean x$4 = header.copy$default$4();
            boolean x$5 = header.copy$default$5();
            boolean x$6 = header.copy$default$6();
            boolean x$7 = header.copy$default$7();
            return header.copy(x$2, (Option<Object>)x$1, x$3, x$4, x$5, x$6, x$7);
        }

        public String toString() {
            return new StringBuilder(9).append("Masking(").append(this.random).append(")").toString();
        }

        public Masking(Random random) {
            this.random = random;
        }
    }
}

