/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import java.awt.Font;
import java.io.IOException;

public class FontProperty
extends AbstractJETAPersistable {
    static final long serialVersionUID = -1878354825497611389L;
    public static final int VERSION = 1;
    private String m_family;
    private int m_style;
    private int m_size;
    private transient Font m_font;

    public FontProperty() {
    }

    public FontProperty(Font font) {
        if (font != null) {
            this.m_family = font.getFamily();
            this.m_style = font.getStyle();
            this.m_size = font.getSize();
            this.m_font = font;
        }
    }

    public Font getFont() {
        if (this.m_font == null) {
            if (this.m_family == null) {
                this.m_family = "Dialog";
            }
            if (this.m_size == 0) {
                this.m_size = 12;
            }
            this.m_font = new Font(this.m_family, this.m_style, this.m_size);
        }
        return this.m_font;
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        int n = jETAObjectInput.readVersion();
        this.m_family = (String)jETAObjectInput.readObject("family");
        this.m_style = jETAObjectInput.readInt("style");
        this.m_size = jETAObjectInput.readInt("size");
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeObject("family", this.m_family);
        jETAObjectOutput.writeInt("style", this.m_style);
        jETAObjectOutput.writeInt("size", this.m_size);
    }
}

