/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.authentication.password.CompromisedPasswordChecker;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

@Order(value=2147478647)
class InitializeUserDetailsBeanManagerConfigurer
extends GlobalAuthenticationConfigurerAdapter {
    static final int DEFAULT_ORDER = 2147478647;
    private final ApplicationContext context;

    InitializeUserDetailsBeanManagerConfigurer(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void init(AuthenticationManagerBuilder auth) throws Exception {
        auth.apply(new InitializeUserDetailsManagerConfigurer());
    }

    class InitializeUserDetailsManagerConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        private final Log logger = LogFactory.getLog(this.getClass());

        InitializeUserDetailsManagerConfigurer() {
        }

        @Override
        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            Object[] beanNames = InitializeUserDetailsBeanManagerConfigurer.this.context.getBeanNamesForType(UserDetailsService.class);
            if (auth.isConfigured()) {
                if (beanNames.length > 0) {
                    this.logger.warn((Object)"Global AuthenticationManager configured with an AuthenticationProvider bean. UserDetailsService beans will not be used for username/password login. Consider removing the AuthenticationProvider bean. Alternatively, consider using the UserDetailsService in a manually instantiated DaoAuthenticationProvider.");
                }
                return;
            }
            if (beanNames.length == 0) {
                return;
            }
            if (beanNames.length > 1) {
                this.logger.warn((Object)LogMessage.format((String)"Found %s UserDetailsService beans, with names %s. Global Authentication Manager will not use a UserDetailsService for username/password login. Consider publishing a single UserDetailsService bean.", (Object)beanNames.length, (Object)Arrays.toString(beanNames)));
                return;
            }
            UserDetailsService userDetailsService = (UserDetailsService)InitializeUserDetailsBeanManagerConfigurer.this.context.getBean(beanNames[0], UserDetailsService.class);
            PasswordEncoder passwordEncoder = this.getBeanOrNull(PasswordEncoder.class);
            UserDetailsPasswordService passwordManager = this.getBeanOrNull(UserDetailsPasswordService.class);
            CompromisedPasswordChecker passwordChecker = this.getBeanOrNull(CompromisedPasswordChecker.class);
            DaoAuthenticationProvider provider = passwordEncoder != null ? new DaoAuthenticationProvider(passwordEncoder) : new DaoAuthenticationProvider();
            provider.setUserDetailsService(userDetailsService);
            if (passwordManager != null) {
                provider.setUserDetailsPasswordService(passwordManager);
            }
            if (passwordChecker != null) {
                provider.setCompromisedPasswordChecker(passwordChecker);
            }
            provider.afterPropertiesSet();
            auth.authenticationProvider((AuthenticationProvider)provider);
            this.logger.info((Object)LogMessage.format((String)"Global AuthenticationManager configured with UserDetailsService bean with name %s", (Object)beanNames[0]));
        }

        private <T> T getBeanOrNull(Class<T> type) {
            String[] beanNames = InitializeUserDetailsBeanManagerConfigurer.this.context.getBeanNamesForType(type);
            if (beanNames.length != 1) {
                return null;
            }
            return (T)InitializeUserDetailsBeanManagerConfigurer.this.context.getBean(beanNames[0], type);
        }
    }
}

