/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.server.servlet;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.security.oauth2.server.servlet.OAuth2AuthorizationServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;

final class OAuth2AuthorizationServerPropertiesMapper {
    private final OAuth2AuthorizationServerProperties properties;

    OAuth2AuthorizationServerPropertiesMapper(OAuth2AuthorizationServerProperties properties) {
        this.properties = properties;
    }

    AuthorizationServerSettings asAuthorizationServerSettings() {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        OAuth2AuthorizationServerProperties.Endpoint endpoint = this.properties.getEndpoint();
        OAuth2AuthorizationServerProperties.OidcEndpoint oidc = endpoint.getOidc();
        AuthorizationServerSettings.Builder builder = AuthorizationServerSettings.builder();
        map.from(this.properties::getIssuer).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).issuer(arg_0));
        map.from(this.properties::isMultipleIssuersAllowed).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).multipleIssuersAllowed(arg_0));
        map.from(endpoint::getAuthorizationUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).authorizationEndpoint(arg_0));
        map.from(endpoint::getDeviceAuthorizationUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).deviceAuthorizationEndpoint(arg_0));
        map.from(endpoint::getDeviceVerificationUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).deviceVerificationEndpoint(arg_0));
        map.from(endpoint::getTokenUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).tokenEndpoint(arg_0));
        map.from(endpoint::getJwkSetUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).jwkSetEndpoint(arg_0));
        map.from(endpoint::getTokenRevocationUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).tokenRevocationEndpoint(arg_0));
        map.from(endpoint::getTokenIntrospectionUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).tokenIntrospectionEndpoint(arg_0));
        map.from(oidc::getLogoutUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).oidcLogoutEndpoint(arg_0));
        map.from(oidc::getClientRegistrationUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).oidcClientRegistrationEndpoint(arg_0));
        map.from(oidc::getUserInfoUri).to(arg_0 -> ((AuthorizationServerSettings.Builder)builder).oidcUserInfoEndpoint(arg_0));
        return builder.build();
    }

    List<RegisteredClient> asRegisteredClients() {
        ArrayList<RegisteredClient> registeredClients = new ArrayList<RegisteredClient>();
        this.properties.getClient().forEach((registrationId, client) -> registeredClients.add(this.getRegisteredClient((String)registrationId, (OAuth2AuthorizationServerProperties.Client)client)));
        return registeredClients;
    }

    private RegisteredClient getRegisteredClient(String registrationId, OAuth2AuthorizationServerProperties.Client client) {
        OAuth2AuthorizationServerProperties.Registration registration = client.getRegistration();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        RegisteredClient.Builder builder = RegisteredClient.withId((String)registrationId);
        map.from(registration::getClientId).to(arg_0 -> ((RegisteredClient.Builder)builder).clientId(arg_0));
        map.from(registration::getClientSecret).to(arg_0 -> ((RegisteredClient.Builder)builder).clientSecret(arg_0));
        map.from(registration::getClientName).to(arg_0 -> ((RegisteredClient.Builder)builder).clientName(arg_0));
        registration.getClientAuthenticationMethods().forEach(clientAuthenticationMethod -> map.from(clientAuthenticationMethod).as(ClientAuthenticationMethod::new).to(arg_0 -> ((RegisteredClient.Builder)builder).clientAuthenticationMethod(arg_0)));
        registration.getAuthorizationGrantTypes().forEach(authorizationGrantType -> map.from(authorizationGrantType).as(AuthorizationGrantType::new).to(arg_0 -> ((RegisteredClient.Builder)builder).authorizationGrantType(arg_0)));
        registration.getRedirectUris().forEach(redirectUri -> map.from(redirectUri).to(arg_0 -> ((RegisteredClient.Builder)builder).redirectUri(arg_0)));
        registration.getPostLogoutRedirectUris().forEach(redirectUri -> map.from(redirectUri).to(arg_0 -> ((RegisteredClient.Builder)builder).postLogoutRedirectUri(arg_0)));
        registration.getScopes().forEach(scope -> map.from(scope).to(arg_0 -> ((RegisteredClient.Builder)builder).scope(arg_0)));
        builder.clientSettings(this.getClientSettings(client, map));
        builder.tokenSettings(this.getTokenSettings(client, map));
        return builder.build();
    }

    private ClientSettings getClientSettings(OAuth2AuthorizationServerProperties.Client client, PropertyMapper map) {
        ClientSettings.Builder builder = ClientSettings.builder();
        map.from(client::isRequireProofKey).to(arg_0 -> ((ClientSettings.Builder)builder).requireProofKey(arg_0));
        map.from(client::isRequireAuthorizationConsent).to(arg_0 -> ((ClientSettings.Builder)builder).requireAuthorizationConsent(arg_0));
        map.from(client::getJwkSetUri).to(arg_0 -> ((ClientSettings.Builder)builder).jwkSetUrl(arg_0));
        map.from(client::getTokenEndpointAuthenticationSigningAlgorithm).as(this::jwsAlgorithm).to(arg_0 -> ((ClientSettings.Builder)builder).tokenEndpointAuthenticationSigningAlgorithm(arg_0));
        return builder.build();
    }

    private TokenSettings getTokenSettings(OAuth2AuthorizationServerProperties.Client client, PropertyMapper map) {
        OAuth2AuthorizationServerProperties.Token token = client.getToken();
        TokenSettings.Builder builder = TokenSettings.builder();
        map.from(token::getAuthorizationCodeTimeToLive).to(arg_0 -> ((TokenSettings.Builder)builder).authorizationCodeTimeToLive(arg_0));
        map.from(token::getAccessTokenTimeToLive).to(arg_0 -> ((TokenSettings.Builder)builder).accessTokenTimeToLive(arg_0));
        map.from(token::getAccessTokenFormat).as(OAuth2TokenFormat::new).to(arg_0 -> ((TokenSettings.Builder)builder).accessTokenFormat(arg_0));
        map.from(token::getDeviceCodeTimeToLive).to(arg_0 -> ((TokenSettings.Builder)builder).deviceCodeTimeToLive(arg_0));
        map.from(token::isReuseRefreshTokens).to(arg_0 -> ((TokenSettings.Builder)builder).reuseRefreshTokens(arg_0));
        map.from(token::getRefreshTokenTimeToLive).to(arg_0 -> ((TokenSettings.Builder)builder).refreshTokenTimeToLive(arg_0));
        map.from(token::getIdTokenSignatureAlgorithm).as(this::signatureAlgorithm).to(arg_0 -> ((TokenSettings.Builder)builder).idTokenSignatureAlgorithm(arg_0));
        return builder.build();
    }

    private JwsAlgorithm jwsAlgorithm(String signingAlgorithm) {
        String name = signingAlgorithm.toUpperCase();
        SignatureAlgorithm jwsAlgorithm = SignatureAlgorithm.from((String)name);
        if (jwsAlgorithm == null) {
            jwsAlgorithm = MacAlgorithm.from((String)name);
        }
        return jwsAlgorithm;
    }

    private SignatureAlgorithm signatureAlgorithm(String signatureAlgorithm) {
        return SignatureAlgorithm.from((String)signatureAlgorithm.toUpperCase());
    }
}

