/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.statistics;

import org.jboss.resteasy.spi.statistics.MethodStatisticsLogger;

public class MethodStatisticsLoggerImpl
implements MethodStatisticsLogger {
    private volatile long invocationCnt = 0L;
    private volatile long failureCnt = 0L;
    private volatile long totalExecutionTime = 0L;

    public long timestamp() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void duration(long fromTimestamp) {
        MethodStatisticsLoggerImpl methodStatisticsLoggerImpl = this;
        synchronized (methodStatisticsLoggerImpl) {
            ++this.invocationCnt;
            this.totalExecutionTime += System.nanoTime() - fromTimestamp;
        }
    }

    public void incFailureCnt() {
        ++this.failureCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        MethodStatisticsLoggerImpl methodStatisticsLoggerImpl = this;
        synchronized (methodStatisticsLoggerImpl) {
            this.invocationCnt = 0L;
            this.failureCnt = 0L;
            this.totalExecutionTime = 0L;
        }
    }

    public long getInvocationCnt() {
        return this.invocationCnt;
    }

    public long getFailedInvocationCnt() {
        return this.failureCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvgExecutionTime() {
        long avgExecTime = -1L;
        MethodStatisticsLoggerImpl methodStatisticsLoggerImpl = this;
        synchronized (methodStatisticsLoggerImpl) {
            block5: {
                try {
                    avgExecTime = this.totalExecutionTime / this.invocationCnt;
                }
                catch (Exception e) {
                    if (this.invocationCnt != 0L || this.totalExecutionTime != 0L) break block5;
                    avgExecTime = 0L;
                }
            }
        }
        return avgExecTime;
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }
}

