/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.i18n;

import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NHelper {
    private Locale m_locale;
    private static I18NHelper m_singleton;
    private LinkedList m_bundles = new LinkedList();

    private I18NHelper() {
    }

    public boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static I18NHelper getInstance() {
        if (m_singleton == null) {
            m_singleton = new I18NHelper();
        }
        return m_singleton;
    }

    public void loadBundle(String string) {
        ResourceBundle resourceBundle = null;
        ResourceLoader resourceLoader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
        resourceBundle = ResourceBundle.getBundle(string, this.m_locale, resourceLoader.getClassLoader());
        this.m_bundles.add(resourceBundle);
    }

    public void setLocale(Locale locale) {
        Locale.setDefault(locale);
        this.m_locale = locale;
    }

    public String format(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.m_locale);
        messageFormat.applyPattern(this.getLocalizedMessage(string));
        return messageFormat.format(objectArray);
    }

    public String _getLocalizedMessage(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public String getLocalizedMessage(String string) {
        ResourceBundle resourceBundle;
        if (string == null) {
            return null;
        }
        String string2 = null;
        Iterator iterator = this.m_bundles.iterator();
        while (iterator.hasNext() && (string2 = this._getLocalizedMessage(resourceBundle = (ResourceBundle)iterator.next(), string)) == null) {
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public boolean toBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.compareToIgnoreCase(this.getLocalizedMessage("true")) == 0;
    }

    public char closeParenthesis() {
        return ')';
    }

    public char comma() {
        return ',';
    }

    public char newline() {
        return '\n';
    }

    public char openParenthesis() {
        return '(';
    }

    public char semicolon() {
        return ';';
    }

    public char space() {
        return ' ';
    }
}

