/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.hibernate;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.hibernate.EventListFactory;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.HashMap;
import java.util.Map;

public final class CategoryEventListFactory
implements EventListFactory {
    private static final Map<String, ListInfo> CATEGORY_MAP = new HashMap<String, ListInfo>();
    private final String category;

    public CategoryEventListFactory(String category) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        this.category = category;
        this.registerCategory(category);
    }

    public CategoryEventListFactory(String category, ReadWriteLock lock, ListEventPublisher publisher) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        if (lock == null) {
            throw new IllegalArgumentException("ReadWriteLock must not be null");
        }
        if (publisher == null) {
            throw new IllegalArgumentException("ListEventPublisher must not be null");
        }
        this.category = category;
        this.registerCategory(category, lock, publisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCategory(String newCategory) {
        Map<String, ListInfo> map = CATEGORY_MAP;
        synchronized (map) {
            if (!CATEGORY_MAP.containsKey(newCategory)) {
                CATEGORY_MAP.put(newCategory, new ListInfo());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCategory(String newCategory, ReadWriteLock lock, ListEventPublisher publisher) {
        Map<String, ListInfo> map = CATEGORY_MAP;
        synchronized (map) {
            if (CATEGORY_MAP.containsKey(newCategory)) {
                ListInfo info = this.getListInfo();
                if (!lock.equals(info.lock) || !publisher.equals(info.publisher)) {
                    throw new IllegalStateException("List category " + newCategory + " already in use with different lock or publisher");
                }
            } else {
                CATEGORY_MAP.put(newCategory, new ListInfo(lock, publisher));
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public EventList createEventList() {
        ListInfo info = this.getListInfo();
        return new BasicEventList(info.publisher, info.lock);
    }

    @Override
    public EventList createEventList(int initalCapacity) {
        ListInfo info = this.getListInfo();
        return new BasicEventList(initalCapacity, info.publisher, info.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListInfo getListInfo() {
        Map<String, ListInfo> map = CATEGORY_MAP;
        synchronized (map) {
            return CATEGORY_MAP.get(this.getCategory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCategoryMapping() {
        Map<String, ListInfo> map = CATEGORY_MAP;
        synchronized (map) {
            CATEGORY_MAP.clear();
        }
    }

    private static class ListInfo {
        public ReadWriteLock lock;
        public ListEventPublisher publisher;

        ListInfo() {
            this.lock = LockFactory.DEFAULT.createReadWriteLock();
            this.publisher = ListEventAssembler.createListEventPublisher();
        }

        ListInfo(ReadWriteLock lock, ListEventPublisher publisher) {
            this.lock = lock;
            this.publisher = publisher;
        }
    }
}

