/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exemplars.DefaultExemplarSampler;
import io.prometheus.client.exemplars.ExemplarSampler;
import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;
import io.prometheus.client.exporter.BasicAuthHttpConnectionFactory;
import io.prometheus.client.exporter.HttpConnectionFactory;
import io.prometheus.client.exporter.PushGateway;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusPushGatewayManager;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="prometheus")
@EnableConfigurationProperties(value={PrometheusProperties.class})
public class PrometheusMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PrometheusConfig prometheusConfig(PrometheusProperties prometheusProperties) {
        return new PrometheusPropertiesConfigAdapter(prometheusProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public PrometheusMeterRegistry prometheusMeterRegistry(PrometheusConfig prometheusConfig, CollectorRegistry collectorRegistry, Clock clock, ObjectProvider<ExemplarSampler> exemplarSamplerProvider) {
        return new PrometheusMeterRegistry(prometheusConfig, collectorRegistry, clock, (ExemplarSampler)exemplarSamplerProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExemplarSampler.class})
    @ConditionalOnBean(value={SpanContextSupplier.class})
    public DefaultExemplarSampler exemplarSampler(SpanContextSupplier spanContextSupplier) {
        return new DefaultExemplarSampler(spanContextSupplier);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={PushGateway.class})
    @ConditionalOnProperty(prefix="management.prometheus.metrics.export.pushgateway", name={"enabled"})
    public static class PrometheusPushGatewayConfiguration {
        private static final String FALLBACK_JOB = "spring";

        @Bean
        @ConditionalOnMissingBean
        public PrometheusPushGatewayManager prometheusPushGatewayManager(CollectorRegistry collectorRegistry, PrometheusProperties prometheusProperties, Environment environment) throws MalformedURLException {
            PrometheusProperties.Pushgateway properties = prometheusProperties.getPushgateway();
            Duration pushRate = properties.getPushRate();
            String job = this.getJob(properties, environment);
            Map<String, String> groupingKey = properties.getGroupingKey();
            PrometheusPushGatewayManager.ShutdownOperation shutdownOperation = properties.getShutdownOperation();
            PushGateway pushGateway = this.initializePushGateway(properties.getBaseUrl());
            if (StringUtils.hasText((String)properties.getUsername())) {
                pushGateway.setConnectionFactory((HttpConnectionFactory)new BasicAuthHttpConnectionFactory(properties.getUsername(), properties.getPassword()));
            }
            return new PrometheusPushGatewayManager(pushGateway, collectorRegistry, pushRate, job, groupingKey, shutdownOperation);
        }

        private PushGateway initializePushGateway(String url) throws MalformedURLException {
            return new PushGateway(new URL(url));
        }

        private String getJob(PrometheusProperties.Pushgateway properties, Environment environment) {
            String job = properties.getJob();
            job = job != null ? job : environment.getProperty("spring.application.name");
            return job != null ? job : FALLBACK_JOB;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnAvailableEndpoint(endpoint=PrometheusScrapeEndpoint.class)
    public static class PrometheusScrapeEndpointConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusScrapeEndpoint(collectorRegistry);
        }
    }
}

