/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.config.server.encryption.KeyStoreTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaAlgorithm;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="encrypt.key-store", value={"location"})
@ConditionalOnClass(value={RsaSecretEncryptor.class})
@EnableConfigurationProperties
public class RsaEncryptionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public KeyProperties keyProperties() {
        return new KeyProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public TextEncryptorLocator textEncryptorLocator(KeyProperties key, RsaProperties rsaProperties) {
        KeyProperties.KeyStore keyStore = key.getKeyStore();
        KeyStoreTextEncryptorLocator locator = new KeyStoreTextEncryptorLocator(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray(), key.getKeyStore().getType()), keyStore.getSecret(), keyStore.getAlias());
        RsaAlgorithm algorithm = rsaProperties.getAlgorithm();
        locator.setRsaAlgorithm(algorithm);
        locator.setSalt(rsaProperties.getSalt());
        locator.setStrong(rsaProperties.isStrong());
        return locator;
    }
}

