/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Path;
import org.springframework.boot.autoconfigure.ssl.BundleContentNotWatchableException;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

record BundleContentProperty(String name, String value) {
    boolean isPemContent() {
        return PemContent.isPresentInText((String)this.value);
    }

    boolean hasValue() {
        return StringUtils.hasText((String)this.value);
    }

    Path toWatchPath() {
        try {
            URL url = this.toUrl();
            if (!this.isFileUrl(url)) {
                throw new BundleContentNotWatchableException(this);
            }
            return Path.of(url.toURI()).toAbsolutePath();
        }
        catch (Exception ex) {
            if (ex instanceof BundleContentNotWatchableException) {
                BundleContentNotWatchableException bundleContentNotWatchableException = (BundleContentNotWatchableException)ex;
                throw bundleContentNotWatchableException;
            }
            throw new IllegalStateException("Unable to convert value of property '%s' to a path".formatted(this.name), ex);
        }
    }

    private URL toUrl() throws FileNotFoundException {
        Assert.state((!this.isPemContent() ? 1 : 0) != 0, (String)"Value contains PEM content");
        return ResourceUtils.getURL((String)this.value);
    }

    private boolean isFileUrl(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol());
    }
}

