/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SysInfo
implements Serializable {
    private static final long serialVersionUID = 16002L;
    String name = null;
    String version = null;
    String arch = null;
    String machine = null;
    String description = null;
    String patchLevel = null;
    String vendor = null;
    String vendorVersion = null;
    String vendorName = null;
    String vendorCodeName = null;

    public native void gather(Sigar var1) throws SigarException;

    static SysInfo fetch(Sigar sigar) throws SigarException {
        SysInfo sysInfo = new SysInfo();
        sysInfo.gather(sigar);
        return sysInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArch() {
        return this.arch;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPatchLevel() {
        return this.patchLevel;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVendorVersion() {
        return this.vendorVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVendorCodeName() {
        return this.vendorCodeName;
    }

    void copyTo(SysInfo copy) {
        copy.name = this.name;
        copy.version = this.version;
        copy.arch = this.arch;
        copy.machine = this.machine;
        copy.description = this.description;
        copy.patchLevel = this.patchLevel;
        copy.vendor = this.vendor;
        copy.vendorVersion = this.vendorVersion;
        copy.vendorName = this.vendorName;
        copy.vendorCodeName = this.vendorCodeName;
    }

    public Map toMap() {
        String strvendorCodeName;
        String strvendorName;
        String strvendorVersion;
        String strvendor;
        String strpatchLevel;
        String strdescription;
        String strmachine;
        String strarch;
        String strversion;
        HashMap<String, String> map = new HashMap<String, String>();
        String strname = String.valueOf(this.name);
        if (!"-1".equals(strname)) {
            map.put("Name", strname);
        }
        if (!"-1".equals(strversion = String.valueOf(this.version))) {
            map.put("Version", strversion);
        }
        if (!"-1".equals(strarch = String.valueOf(this.arch))) {
            map.put("Arch", strarch);
        }
        if (!"-1".equals(strmachine = String.valueOf(this.machine))) {
            map.put("Machine", strmachine);
        }
        if (!"-1".equals(strdescription = String.valueOf(this.description))) {
            map.put("Description", strdescription);
        }
        if (!"-1".equals(strpatchLevel = String.valueOf(this.patchLevel))) {
            map.put("PatchLevel", strpatchLevel);
        }
        if (!"-1".equals(strvendor = String.valueOf(this.vendor))) {
            map.put("Vendor", strvendor);
        }
        if (!"-1".equals(strvendorVersion = String.valueOf(this.vendorVersion))) {
            map.put("VendorVersion", strvendorVersion);
        }
        if (!"-1".equals(strvendorName = String.valueOf(this.vendorName))) {
            map.put("VendorName", strvendorName);
        }
        if (!"-1".equals(strvendorCodeName = String.valueOf(this.vendorCodeName))) {
            map.put("VendorCodeName", strvendorCodeName);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

