/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.context;

import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

@Endpoint(id="shutdown", enableByDefault=false)
public class ShutdownEndpoint
implements ApplicationContextAware {
    private ConfigurableApplicationContext context;

    @WriteOperation
    public ShutdownDescriptor shutdown() {
        if (this.context == null) {
            return ShutdownDescriptor.NO_CONTEXT;
        }
        try {
            ShutdownDescriptor shutdownDescriptor = ShutdownDescriptor.DEFAULT;
            return shutdownDescriptor;
        }
        finally {
            Thread thread = new Thread(this::performShutdown);
            thread.setContextClassLoader(this.getClass().getClassLoader());
            thread.start();
        }
    }

    private void performShutdown() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.context.close();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext;
            this.context = configurableContext = (ConfigurableApplicationContext)context;
        }
    }

    public static class ShutdownDescriptor
    implements OperationResponseBody {
        private static final ShutdownDescriptor DEFAULT = new ShutdownDescriptor("Shutting down, bye...");
        private static final ShutdownDescriptor NO_CONTEXT = new ShutdownDescriptor("No context to shutdown.");
        private final String message;

        ShutdownDescriptor(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

