/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.bootstrap.support.OriginTrackedCompositePropertySource;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRequestTemplateFactory;
import org.springframework.cloud.config.client.ConfigClientStateHolder;
import org.springframework.cloud.config.client.validation.InvalidApplicationNameException;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Order(value=0)
public class ConfigServicePropertySourceLocator
implements PropertySourceLocator {
    private static Log logger = LogFactory.getLog(ConfigServicePropertySourceLocator.class);
    private RestTemplate restTemplate;
    private ConfigClientProperties defaultProperties;

    public ConfigServicePropertySourceLocator(ConfigClientProperties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    private List<String> combineProfiles(ConfigClientProperties properties, org.springframework.core.env.Environment environment) {
        List<String> combinedProfiles = new ArrayList<String>();
        if (environment.getActiveProfiles().length > 0) {
            ArrayList<String> finalCombinedProfiles = combinedProfiles;
            List filteredActiveProfiles = Stream.of(environment.getActiveProfiles()).filter(s -> !finalCombinedProfiles.contains(s)).collect(Collectors.toList());
            combinedProfiles.addAll(filteredActiveProfiles);
        } else if (environment.getDefaultProfiles().length > 0 && combinedProfiles.isEmpty()) {
            combinedProfiles = Arrays.asList(environment.getDefaultProfiles());
        }
        return combinedProfiles;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public PropertySource<?> locate(org.springframework.core.env.Environment environment) {
        ConfigClientProperties properties = this.defaultProperties.override(environment);
        if (!StringUtils.hasText((String)properties.getProfile())) {
            properties.setProfile(String.join((CharSequence)",", this.combineProfiles(properties, environment)));
        }
        if (StringUtils.startsWithIgnoreCase((String)properties.getName(), (String)"application-")) {
            InvalidApplicationNameException exception = new InvalidApplicationNameException(properties.getName());
            if (properties.isFailFast()) {
                throw exception;
            }
            logger.warn((Object)("${spring.cloud.config.name:${spring.application.name:application}} resolved to " + properties.getName() + ", not going to load remote properties. Ensure application name doesn't start with 'application-'"));
            return null;
        }
        OriginTrackedCompositePropertySource composite = new OriginTrackedCompositePropertySource("configService");
        ConfigClientRequestTemplateFactory requestTemplateFactory = new ConfigClientRequestTemplateFactory(logger, properties);
        Throwable error = null;
        String errorBody = null;
        try {
            Object[] labels = new String[]{""};
            if (StringUtils.hasText((String)properties.getLabel())) {
                labels = StringUtils.commaDelimitedListToStringArray((String)properties.getLabel());
            }
            String state = ConfigClientStateHolder.getState();
            for (String string : labels) {
                Environment result = this.getRemoteEnvironment(requestTemplateFactory, string.trim(), state);
                if (result == null) continue;
                this.log(result);
                if (result.getPropertySources() != null) {
                    for (org.springframework.cloud.config.environment.PropertySource source : result.getPropertySources()) {
                        Map<String, Object> map = this.translateOrigins(source.getName(), source.getSource());
                        composite.addPropertySource((PropertySource)new OriginTrackedMapPropertySource(source.getName(), map));
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (StringUtils.hasText((String)result.getState())) {
                    this.putValue(map, "config.client.state", result.getState());
                }
                if (StringUtils.hasText((String)result.getVersion())) {
                    this.putValue(map, "config.client.version", result.getVersion());
                }
                composite.addFirstPropertySource((PropertySource)new MapPropertySource("configClient", map));
                return composite;
            }
            errorBody = String.format("None of labels %s found", Arrays.toString(labels));
        }
        catch (HttpServerErrorException e) {
            error = e;
            if (MediaType.APPLICATION_JSON.includes(e.getResponseHeaders().getContentType())) {
                errorBody = e.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            error = e;
        }
        if (properties.isFailFast()) {
            throw new IllegalStateException("Could not locate PropertySource and the fail fast property is set, failing" + (String)(errorBody == null ? "" : ": " + errorBody), error);
        }
        logger.warn((Object)("Could not locate PropertySource: " + (error != null ? error.getMessage() : errorBody)));
        return null;
    }

    @Retryable(interceptor="configServerRetryInterceptor")
    public Collection<PropertySource<?>> locateCollection(org.springframework.core.env.Environment environment) {
        return PropertySourceLocator.locateCollection((PropertySourceLocator)this, (org.springframework.core.env.Environment)environment);
    }

    private void log(Environment result) {
        List<org.springframework.cloud.config.environment.PropertySource> propertySourceList;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Located environment: name=%s, profiles=%s, label=%s, version=%s, state=%s", result.getName(), result.getProfiles() == null ? "" : Arrays.asList(result.getProfiles()), result.getLabel(), result.getVersion(), result.getState()));
        }
        if (logger.isDebugEnabled() && (propertySourceList = result.getPropertySources()) != null) {
            int propertyCount = 0;
            for (org.springframework.cloud.config.environment.PropertySource propertySource : propertySourceList) {
                propertyCount += propertySource.getSource().size();
            }
            logger.debug((Object)String.format("Environment %s has %d property sources with %d properties.", result.getName(), result.getPropertySources().size(), propertyCount));
        }
    }

    private Map<String, Object> translateOrigins(String name, Map<String, Object> source) {
        LinkedHashMap<String, Object> withOrigins = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Map value;
            boolean hasOrigin = false;
            if (entry.getValue() instanceof Map && (value = (Map)entry.getValue()).size() == 2 && value.containsKey("origin") && value.containsKey("value")) {
                ConfigServiceOrigin origin = new ConfigServiceOrigin(name, value.get("origin"));
                OriginTrackedValue trackedValue = OriginTrackedValue.of(value.get("value"), (Origin)origin);
                withOrigins.put(entry.getKey(), trackedValue);
                hasOrigin = true;
            }
            if (hasOrigin) continue;
            withOrigins.put(entry.getKey(), entry.getValue());
        }
        return withOrigins;
    }

    private void putValue(HashMap<String, Object> map, String key, String value) {
        if (StringUtils.hasText((String)value)) {
            map.put(key, value);
        }
    }

    private Environment getRemoteEnvironment(ConfigClientRequestTemplateFactory requestTemplateFactory, String label, String state) {
        RestTemplate restTemplate = this.restTemplate == null ? requestTemplateFactory.create() : this.restTemplate;
        ConfigClientProperties properties = requestTemplateFactory.getProperties();
        Object path = "/{name}/{profile}";
        String name = properties.getName();
        String profile = properties.getProfile();
        String token = properties.getToken();
        int noOfUrls = properties.getUri().length;
        if (noOfUrls > 1) {
            logger.info((Object)"Multiple Config Server Urls found listed.");
        }
        Object[] args = new String[]{name, profile};
        if (StringUtils.hasText((String)label)) {
            label = Environment.denormalize(label);
            args = new String[]{name, profile, label};
            path = (String)path + "/{label}";
        }
        ResponseEntity response = null;
        List<MediaType> acceptHeader = Collections.singletonList(MediaType.parseMediaType((String)properties.getMediaType()));
        for (int i = 0; i < noOfUrls; ++i) {
            ConfigClientProperties.Credentials credentials = properties.getCredentials(i);
            String uri = credentials.getUri();
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            logger.info((Object)("Fetching config from server at : " + uri));
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept(acceptHeader);
                requestTemplateFactory.addAuthorizationToken(headers, username, password);
                if (StringUtils.hasText((String)token)) {
                    headers.add("X-Config-Token", token);
                }
                if (StringUtils.hasText((String)state) && properties.isSendState()) {
                    headers.add("X-Config-State", state);
                }
                HttpEntity entity = new HttpEntity((Object)null, (MultiValueMap)headers);
                response = restTemplate.exchange(uri + (String)path, HttpMethod.GET, entity, Environment.class, args);
            }
            catch (HttpClientErrorException | HttpServerErrorException e) {
                if (i < noOfUrls - 1 && this.defaultProperties.getMultipleUriStrategy() == ConfigClientProperties.MultipleUriStrategy.ALWAYS) {
                    logger.info((Object)("Failed to fetch configs from server at  : " + uri + ". Will try the next url if available. Error : " + e.getMessage()));
                    continue;
                }
                if (e.getStatusCode() != HttpStatus.NOT_FOUND) {
                    throw e;
                }
            }
            catch (ResourceAccessException e) {
                logger.info((Object)("Exception on Url - " + uri + ":" + e + ". Will be trying the next url if available"));
                if (i != noOfUrls - 1) continue;
                throw e;
            }
            if (response == null || response.getStatusCode() != HttpStatus.OK) {
                return null;
            }
            Environment result = (Environment)response.getBody();
            return result;
        }
        return null;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    static class ConfigServiceOrigin
    implements Origin {
        private final String remotePropertySource;
        private final Object origin;

        ConfigServiceOrigin(String remotePropertySource, Object origin) {
            this.remotePropertySource = remotePropertySource;
            Assert.notNull((Object)origin, (String)"origin may not be null");
            this.origin = origin;
        }

        public String toString() {
            return "Config Server " + this.remotePropertySource + ":" + this.origin.toString();
        }
    }

    @Deprecated
    public static class GenericRequestHeaderInterceptor
    extends ConfigClientRequestTemplateFactory.GenericRequestHeaderInterceptor {
        public GenericRequestHeaderInterceptor(Map<String, String> headers) {
            super(headers);
        }
    }
}

