/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.server.internal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.websocket.server.HandshakeRequest;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

public class JsrHandshakeRequest
implements HandshakeRequest {
    private final ServerUpgradeRequest delegate;
    private final HttpServletRequest httpServletRequest;
    private Map<String, List<String>> parameterMap;

    public JsrHandshakeRequest(ServerUpgradeRequest req) {
        this.delegate = req;
        this.httpServletRequest = (HttpServletRequest)req.getAttribute("org.eclipse.jetty.websocket.wrappedRequest");
    }

    public Map<String, List<String>> getHeaders() {
        Map<String, List> headers = this.delegate.getHeaders().getFieldNamesCollection().stream().collect(Collectors.toMap(name -> name, name -> new ArrayList(this.delegate.getHeaders().getValuesList(name))));
        return Collections.unmodifiableMap(headers);
    }

    public Object getHttpSession() {
        return this.httpServletRequest.getSession(false);
    }

    public Map<String, List<String>> getParameterMap() {
        if (this.parameterMap == null) {
            Fields requestParams = Request.extractQueryParameters((Request)this.delegate);
            this.parameterMap = new HashMap<String, List<String>>();
            for (String name : requestParams.getNames()) {
                this.parameterMap.put(name, requestParams.getValues(name));
            }
        }
        return this.parameterMap;
    }

    public String getQueryString() {
        return this.delegate.getHttpURI().getQuery();
    }

    public PathSpec getRequestPathSpec() {
        return (PathSpec)this.delegate.getAttribute(PathSpec.class.getName());
    }

    public Map<String, String> getPathParams() {
        return (Map)this.delegate.getAttribute("jakarta.websocket.server.pathParams");
    }

    public URI getRequestURI() {
        return this.delegate.getHttpURI().toURI();
    }

    public Principal getUserPrincipal() {
        return this.httpServletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.httpServletRequest.isUserInRole(role);
    }
}

