/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Deprecated(since="3.1.0", forRemoval=true)
public class MongoPropertiesClientSettingsBuilderCustomizer
implements MongoClientSettingsBuilderCustomizer,
Ordered {
    private final MongoProperties properties;
    private int order = 0;

    public MongoPropertiesClientSettingsBuilderCustomizer(MongoProperties properties) {
        this.properties = properties;
    }

    @Override
    public void customize(MongoClientSettings.Builder settingsBuilder) {
        this.applyUuidRepresentation(settingsBuilder);
        this.applyHostAndPort(settingsBuilder);
        this.applyCredentials(settingsBuilder);
        this.applyReplicaSet(settingsBuilder);
    }

    private void applyUuidRepresentation(MongoClientSettings.Builder settingsBuilder) {
        settingsBuilder.uuidRepresentation(this.properties.getUuidRepresentation());
    }

    private void applyHostAndPort(MongoClientSettings.Builder settings) {
        if (this.properties.getUri() != null) {
            settings.applyConnectionString(new ConnectionString(this.properties.getUri()));
            return;
        }
        if (this.properties.getHost() != null || this.properties.getPort() != null) {
            String host = this.getOrDefault(this.properties.getHost(), "localhost");
            int port = this.getOrDefault(this.properties.getPort(), 27017);
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
            serverAddresses.add(new ServerAddress(host, port));
            if (!CollectionUtils.isEmpty(this.properties.getAdditionalHosts())) {
                this.properties.getAdditionalHosts().stream().map(ServerAddress::new).forEach(serverAddresses::add);
            }
            settings.applyToClusterSettings(cluster -> cluster.hosts(serverAddresses));
            return;
        }
        settings.applyConnectionString(new ConnectionString("mongodb://localhost/test"));
    }

    private void applyCredentials(MongoClientSettings.Builder builder) {
        if (this.properties.getUri() == null && this.properties.getUsername() != null && this.properties.getPassword() != null) {
            String database = this.properties.getAuthenticationDatabase() != null ? this.properties.getAuthenticationDatabase() : this.properties.getMongoClientDatabase();
            builder.credential(MongoCredential.createCredential((String)this.properties.getUsername(), (String)database, (char[])this.properties.getPassword()));
        }
    }

    private void applyReplicaSet(MongoClientSettings.Builder builder) {
        if (StringUtils.hasText((String)this.properties.getReplicaSetName())) {
            builder.applyToClusterSettings(cluster -> cluster.requiredReplicaSetName(this.properties.getReplicaSetName()));
        }
    }

    private <V> V getOrDefault(V value, V defaultValue) {
        return value != null ? value : defaultValue;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

