/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.matchers;

import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class WeakReferenceMatcherEditor<E>
implements MatcherEditor<E>,
MatcherEditor.Listener<E> {
    private final List<MatcherEditor.Listener<E>> listenerList = new ArrayList<MatcherEditor.Listener<E>>();
    private MatcherEditor<E> source;

    public WeakReferenceMatcherEditor(MatcherEditor<E> source) {
        this.source = source;
        source.addMatcherEditorListener(new WeakMatcherEditorListener<E>(source, this));
    }

    @Override
    public Matcher<E> getMatcher() {
        return this.source.getMatcher();
    }

    @Override
    public synchronized void addMatcherEditorListener(MatcherEditor.Listener<E> listener) {
        this.listenerList.add(new WeakMatcherEditorListener<E>(this, listener));
    }

    @Override
    public synchronized void removeMatcherEditorListener(MatcherEditor.Listener<E> listener) {
        Iterator<MatcherEditor.Listener<E>> it = this.listenerList.iterator();
        while (it.hasNext()) {
            WeakMatcherEditorListener weakMatcherEditorListener;
            MatcherEditor.Listener referent;
            MatcherEditor.Listener<E> currentListener = it.next();
            if (currentListener == listener) {
                it.remove();
                continue;
            }
            if (!(currentListener instanceof WeakMatcherEditorListener) || (referent = (weakMatcherEditorListener = (WeakMatcherEditorListener)currentListener).getDecoratedListener()) != listener) continue;
            it.remove();
        }
    }

    @Override
    public synchronized void changedMatcher(MatcherEditor.Event<E> matcherEvent) {
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).changedMatcher(matcherEvent);
        }
    }

    private class WeakMatcherEditorListener<E>
    implements MatcherEditor.Listener<E> {
        private final WeakReference<MatcherEditor.Listener<E>> weakListener;
        private final MatcherEditor<E> editor;

        public WeakMatcherEditorListener(MatcherEditor<E> editor, MatcherEditor.Listener<E> listener) {
            this.weakListener = new WeakReference<MatcherEditor.Listener<E>>(listener);
            this.editor = editor;
        }

        public MatcherEditor.Listener<E> getDecoratedListener() {
            return (MatcherEditor.Listener)this.weakListener.get();
        }

        @Override
        public void changedMatcher(MatcherEditor.Event<E> matcherEvent) {
            MatcherEditor.Listener matcherEditorListener = (MatcherEditor.Listener)this.weakListener.get();
            if (matcherEditorListener == null) {
                this.editor.removeMatcherEditorListener(this);
            } else {
                matcherEvent = new MatcherEditor.Event<E>(WeakReferenceMatcherEditor.this, matcherEvent.getType(), matcherEvent.getMatcher());
                matcherEditorListener.changedMatcher(matcherEvent);
            }
        }
    }
}

