/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse.client;

import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceScheduler;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class SseEventSourceImpl
implements SseEventSource {
    public static final long RECONNECT_DEFAULT = 500L;
    private final WebTarget target;
    private final long reconnectDelay;
    private final SseEventSourceScheduler sseEventSourceScheduler;
    private final AtomicReference<State> state = new AtomicReference<State>(State.PENDING);
    private final List<Consumer<InboundSseEvent>> onEventConsumers = new CopyOnWriteArrayList<Consumer<InboundSseEvent>>();
    private final List<Consumer<Throwable>> onErrorConsumers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> onCompleteConsumers = new CopyOnWriteArrayList<Runnable>();
    private final AtomicBoolean completeListenersInvoked = new AtomicBoolean(false);
    private final boolean alwaysReconnect;
    private volatile ClientResponse response;

    public SseEventSourceImpl(WebTarget target) {
        this(target, true);
    }

    public SseEventSourceImpl(WebTarget target, boolean open) {
        this(target, null, 500L, open, null, true);
    }

    private SseEventSourceImpl(WebTarget target, String name, long reconnectDelay, boolean open, ScheduledExecutorService executor, boolean alwaysReconnect) {
        if (target == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.webTargetIsNotSetForEventSource());
        }
        this.target = target;
        this.reconnectDelay = reconnectDelay;
        this.alwaysReconnect = alwaysReconnect;
        if (executor == null) {
            ScheduledExecutorService scheduledExecutor = null;
            if (target instanceof ResteasyWebTarget) {
                scheduledExecutor = ((ResteasyWebTarget)target).getResteasyClient().getScheduledExecutor();
            }
            this.sseEventSourceScheduler = name != null ? new SseEventSourceScheduler(scheduledExecutor, name) : new SseEventSourceScheduler(scheduledExecutor, String.format("sse-event-source(%s)", target.getUri()));
        } else {
            this.sseEventSourceScheduler = name != null ? new SseEventSourceScheduler(executor, name) : new SseEventSourceScheduler(executor, String.format("sse-event-source(%s)", target.getUri()));
        }
        if (open) {
            this.open();
        }
    }

    public void open() {
        this.open(null);
    }

    public void open(String lastEventId) {
        this.open(lastEventId, "GET", null, MediaType.SERVER_SENT_EVENTS_TYPE);
    }

    public void open(String lastEventId, String verb, Entity<?> entity, MediaType ... mediaTypes) {
        if (!this.state.compareAndSet(State.PENDING, State.OPEN)) {
            throw new IllegalStateException(Messages.MESSAGES.eventSourceIsNotReadyForOpen());
        }
        EventHandler handler = new EventHandler(this.reconnectDelay, lastEventId, verb, entity, mediaTypes);
        this.sseEventSourceScheduler.schedule(handler, 0L, TimeUnit.SECONDS);
        handler.awaitConnected();
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN;
    }

    public void register(Consumer<InboundSseEvent> onEvent) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        if (onError == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
        this.onErrorConsumers.add(onError);
    }

    public void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        if (onEvent == null) {
            throw new IllegalArgumentException();
        }
        if (onError == null) {
            throw new IllegalArgumentException();
        }
        if (onComplete == null) {
            throw new IllegalArgumentException();
        }
        this.onEventConsumers.add(onEvent);
        this.onErrorConsumers.add(onError);
        this.onCompleteConsumers.add(onComplete);
    }

    public boolean close(long timeout, TimeUnit unit) {
        this.internalClose();
        try {
            return this.sseEventSourceScheduler.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            this.onErrorConsumers.forEach(consumer -> consumer.accept(e));
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void runCompleteConsumers() {
        if (this.completeListenersInvoked.compareAndSet(false, true)) {
            this.onCompleteConsumers.forEach(Runnable::run);
        }
    }

    private void internalClose() {
        if (this.state.getAndSet(State.CLOSED) == State.CLOSED) {
            return;
        }
        ClientResponse clientResponse = this.response;
        if (clientResponse != null) {
            try {
                clientResponse.releaseConnection(false);
            }
            catch (IOException e) {
                this.onErrorConsumers.forEach(consumer -> consumer.accept(e));
            }
        }
        this.sseEventSourceScheduler.shutdownNow();
        this.runCompleteConsumers();
    }

    private class EventHandler
    implements Runnable {
        private final CountDownLatch connectedLatch;
        private String lastEventId;
        private long reconnectDelay;
        private String verb;
        private Entity<?> entity;
        private MediaType[] mediaTypes;

        EventHandler(long reconnectDelay, String lastEventId, String verb, Entity<?> entity, MediaType ... mediaTypes) {
            this.connectedLatch = new CountDownLatch(1);
            this.reconnectDelay = reconnectDelay;
            this.lastEventId = lastEventId;
            this.verb = verb;
            this.entity = entity;
            this.mediaTypes = mediaTypes;
        }

        private EventHandler(EventHandler anotherHandler) {
            this.connectedLatch = anotherHandler.connectedLatch;
            this.reconnectDelay = anotherHandler.reconnectDelay;
            this.lastEventId = anotherHandler.lastEventId;
            this.verb = anotherHandler.verb;
            this.entity = anotherHandler.entity;
            this.mediaTypes = anotherHandler.mediaTypes;
        }

        @Override
        public void run() {
            if (SseEventSourceImpl.this.state.get() != State.OPEN) {
                return;
            }
            SseEventInputImpl eventInput = null;
            try {
                ClientResponse clientResponse;
                Invocation.Builder requestBuilder = this.buildRequest(this.mediaTypes);
                Invocation request = null;
                request = this.entity == null ? requestBuilder.build(this.verb) : requestBuilder.build(this.verb, this.entity);
                SseEventSourceImpl.this.response = clientResponse = (ClientResponse)request.invoke();
                if (Response.Status.Family.SUCCESSFUL.equals((Object)clientResponse.getStatusInfo().getFamily())) {
                    this.onConnection();
                    if (clientResponse.getStatus() == 204) {
                        SseEventSourceImpl.this.runCompleteConsumers();
                        return;
                    }
                    eventInput = (SseEventInputImpl)clientResponse.readEntity(SseEventInputImpl.class);
                    if (eventInput == null) {
                        if (!SseEventSourceImpl.this.alwaysReconnect) {
                            SseEventSourceImpl.this.internalClose();
                        } else {
                            this.reconnect(this.reconnectDelay);
                        }
                        return;
                    }
                } else {
                    clientResponse.bufferEntity();
                    ClientInvocation.handleErrorStatus((Response)clientResponse);
                }
            }
            catch (ServiceUnavailableException ex) {
                if (ex.hasRetryAfter()) {
                    this.onConnection();
                    Date requestTime = new Date();
                    long localReconnectDelay = ex.getRetryTime(requestTime).getTime() - requestTime.getTime();
                    this.reconnect(localReconnectDelay);
                } else {
                    this.onUnrecoverableError(ex);
                }
                return;
            }
            catch (Throwable e) {
                this.onUnrecoverableError(e);
                return;
            }
            ClientConfiguration providers = (ClientConfiguration)SseEventSourceImpl.this.target.getConfiguration();
            while (!Thread.currentThread().isInterrupted() && SseEventSourceImpl.this.state.get() == State.OPEN) {
                if (eventInput == null || eventInput.isClosed()) {
                    if (SseEventSourceImpl.this.alwaysReconnect) {
                        this.reconnect(this.reconnectDelay);
                        break;
                    }
                    SseEventSourceImpl.this.internalClose();
                    break;
                }
                try {
                    InboundSseEvent event = eventInput.read((Providers)providers);
                    if (event == null) continue;
                    this.onEvent(event);
                }
                catch (IOException e) {
                    this.reconnect(this.reconnectDelay);
                    break;
                }
            }
        }

        public void awaitConnected() {
            try {
                this.connectedLatch.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        private void onConnection() {
            this.connectedLatch.countDown();
        }

        private void onUnrecoverableError(Throwable throwable) {
            this.connectedLatch.countDown();
            SseEventSourceImpl.this.onErrorConsumers.forEach(consumer -> consumer.accept(throwable));
            SseEventSourceImpl.this.internalClose();
        }

        private void onEvent(InboundSseEvent event) {
            if (event.getId() != null) {
                this.lastEventId = event.getId();
            }
            if (event.isReconnectDelaySet()) {
                this.reconnectDelay = event.getReconnectDelay();
            }
            SseEventSourceImpl.this.onEventConsumers.forEach(consumer -> consumer.accept(event));
        }

        private Invocation.Builder buildRequest(MediaType ... mediaTypes) {
            Invocation.Builder request;
            Invocation.Builder builder = request = mediaTypes != null && mediaTypes.length > 0 ? SseEventSourceImpl.this.target.request(mediaTypes) : SseEventSourceImpl.this.target.request();
            if (this.lastEventId != null && !this.lastEventId.isEmpty()) {
                request.header("Last-Event-ID", (Object)this.lastEventId);
            }
            return request;
        }

        private void reconnect(long delay) {
            if (SseEventSourceImpl.this.state.get() != State.OPEN) {
                return;
            }
            EventHandler processor = new EventHandler(this);
            SseEventSourceImpl.this.sseEventSourceScheduler.schedule(processor, delay, TimeUnit.MILLISECONDS);
        }
    }

    public static class SourceBuilder
    extends SseEventSource.Builder {
        private WebTarget target = null;
        private long reconnect = 500L;
        private String name = null;
        private ScheduledExecutorService executor;
        private boolean alwaysReconnect = true;

        public SseEventSource.Builder named(String name) {
            this.name = name;
            return this;
        }

        public SseEventSource build() {
            return new SseEventSourceImpl(this.target, this.name, this.reconnect, false, this.executor, this.alwaysReconnect);
        }

        public SseEventSource.Builder target(WebTarget target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
            return this;
        }

        public SseEventSource.Builder reconnectingEvery(long delay, TimeUnit unit) {
            this.reconnect = unit.toMillis(delay);
            return this;
        }

        public SseEventSource.Builder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public SseEventSource.Builder alwaysReconnect(boolean alwaysReconnect) {
            this.alwaysReconnect = alwaysReconnect;
            return this;
        }
    }

    private static enum State {
        PENDING,
        OPEN,
        CLOSED;

    }
}

