/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.ram.RamFileData;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;

public class RamFileSystem
extends AbstractFileSystem
implements Serializable {
    private static final int BUFFER_SIZE = 512;
    private static final long serialVersionUID = 20101208L;
    private final Map<FileName, RamFileData> cache = Collections.synchronizedMap(new HashMap());

    protected RamFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        RamFileData rootData = new RamFileData(rootName);
        rootData.setType(FileType.FOLDER);
        rootData.setLastModified(System.currentTimeMillis());
        this.cache.put(rootName, rootData);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new RamFileObject(name, this);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(RamFileProvider.capabilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] listChildren(FileName name) {
        String[] names;
        Collection<RamFileData> children;
        RamFileData data = this.cache.get(name);
        if (data == null || !data.getType().hasChildren()) {
            return null;
        }
        Collection<RamFileData> collection = children = data.getChildren();
        synchronized (collection) {
            names = new String[children.size()];
            int pos = 0;
            for (RamFileData childData : children) {
                names[pos] = childData.getName().getBaseName();
                ++pos;
            }
        }
        return names;
    }

    void delete(RamFileObject file) throws FileSystemException {
        if (file.getParent() == null) {
            throw new FileSystemException("unable to delete root");
        }
        this.cache.remove(file.getName());
        RamFileObject parent = (RamFileObject)this.resolveFile(file.getParent().getName());
        parent.getData().removeChild(file.getData());
        parent.close();
        file.getData().clear();
        file.close();
    }

    void save(RamFileObject file) throws FileSystemException {
        RamFileData parentData;
        if (file.getData().getName() == null) {
            throw new FileSystemException(new IllegalStateException("The data has no name. " + file));
        }
        if (file.getName().getDepth() > 0 && !(parentData = this.cache.get(file.getParent().getName())).hasChildren(file.getData())) {
            RamFileObject parent = (RamFileObject)file.getParent();
            parent.getData().addChild(file.getData());
            parent.close();
        }
        this.cache.put(file.getName(), file.getData());
        file.getData().updateLastModified();
        file.close();
    }

    void rename(RamFileObject from, RamFileObject to) throws FileSystemException {
        if (!this.cache.containsKey(from.getName())) {
            throw new FileSystemException("File does not exist: " + from.getName());
        }
        to.getData().setContent(from.getData().getContent());
        to.getData().setLastModified(from.getData().getLastModified());
        to.getData().setType(from.getData().getType());
        this.save(to);
        this.delete(from);
    }

    public void attach(RamFileObject fo) {
        if (fo.getName() == null) {
            throw new IllegalArgumentException("Null argument");
        }
        RamFileData data = this.cache.get(fo.getName());
        if (data == null) {
            data = new RamFileData(fo.getName());
        }
        fo.setData(data);
    }

    public void importTree(File file) throws FileSystemException {
        FileObject fileFo = this.getFileSystemManager().toFileObject(file);
        this.toRamFileObject(fileFo, fileFo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toRamFileObject(FileObject fo, FileObject root) throws FileSystemException {
        block14: {
            RamFileObject memFo = (RamFileObject)this.resolveFile(fo.getName().getPath().substring(root.getName().getPath().length()));
            if (fo.getType().hasChildren()) {
                FileObject[] fos;
                memFo.createFolder();
                for (FileObject child : fos = fo.getChildren()) {
                    this.toRamFileObject(child, root);
                }
            } else {
                if (fo.isFile()) {
                    try {
                        InputStream is = fo.getContent().getInputStream();
                        try {
                            int i;
                            BufferedOutputStream os = new BufferedOutputStream(memFo.getOutputStream(), 512);
                            while ((i = is.read()) != -1) {
                                ((OutputStream)os).write(i);
                            }
                            ((OutputStream)os).close();
                            break block14;
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (IOException e) {
                        throw new FileSystemException(e.getClass().getName() + " " + e.getMessage());
                    }
                }
                throw new FileSystemException("File is not a folder nor a file " + memFo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long size() {
        long size = 0L;
        Map<FileName, RamFileData> map = this.cache;
        synchronized (map) {
            for (RamFileData data : this.cache.values()) {
                size += (long)data.size();
            }
        }
        return size;
    }

    @Override
    public void close() {
        this.cache.clear();
        super.close();
    }
}

