/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install.driver;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.driver.DriverException;
import org.python.util.install.driver.NormalVerifier;

public class StandaloneVerifier
extends NormalVerifier {
    @Override
    public void verify() throws DriverException {
        if (this.getTargetDir().listFiles().length > 1) {
            throw new DriverException("more than jython.jar installed");
        }
        this.verifyJythonJar();
        super.verify();
    }

    @Override
    protected String[] getSimpleCommand() throws DriverException {
        String parentDirName = null;
        try {
            parentDirName = this.getTargetDir().getCanonicalPath() + File.separator;
        }
        catch (IOException ioe) {
            throw new DriverException(ioe);
        }
        String[] command = new String[]{new JavaHomeHandler().getExecutableName(), "-jar", parentDirName + "jython.jar", parentDirName + "autotest.py"};
        return command;
    }

    @Override
    protected boolean doShellScriptTests() {
        return false;
    }

    private void verifyJythonJar() throws DriverException {
        File jythonJar = this.getTargetDir().listFiles()[0];
        JarFile jar = null;
        try {
            jar = new JarFile(jythonJar);
            if (jar.getManifest() == null) {
                throw new DriverException("jython.jar contains no MANIFEST");
            }
            boolean hasLibDir = false;
            Enumeration<JarEntry> entries = jar.entries();
            while (!hasLibDir && entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("Lib/")) continue;
                hasLibDir = true;
            }
            if (!hasLibDir) {
                throw new DriverException("jython.jar contains no /Lib directory");
            }
        }
        catch (IOException e) {
            throw new DriverException(e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

