/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install.driver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.python.util.install.ChildProcess;
import org.python.util.install.FileHelper;
import org.python.util.install.driver.DriverException;
import org.python.util.install.driver.Verifier;

public class NormalVerifier
implements Verifier {
    protected static final String AUTOTEST_PY = "autotest.py";
    private static final String BIN = "bin";
    private static final String JYTHON_UP = "jython up and running!";
    private static final String JYTHON = "jython";
    private static final String VERIFYING = "verifying";
    private File _targetDir;

    @Override
    public void setTargetDir(File targetDir) {
        this._targetDir = targetDir;
    }

    @Override
    public File getTargetDir() {
        return this._targetDir;
    }

    @Override
    public void verify() throws DriverException {
        this.createTestScriptFile();
        this.verifyStart(this.getSimpleCommand());
    }

    protected String[] getSimpleCommand() throws DriverException {
        return new String[]{Paths.get(BIN, new String[0]).resolve(JYTHON).toString(), this._targetDir.toPath().resolve(AUTOTEST_PY).toString()};
    }

    protected final File getShellScriptTestCommandDir() throws DriverException {
        return this._targetDir.toPath().resolve(BIN).toFile();
    }

    private void verifyStart(String[] command) throws DriverException {
        ChildProcess p = new ChildProcess(command);
        p.setDebug(true);
        p.setCWD(this._targetDir.toPath());
        System.err.println("Verify start: command=" + Arrays.toString(command) + ", cwd=" + p.getCWD());
        int exitValue = p.run();
        this.verifyError(p.getStderr());
        this.verifyOutput(p.getStdout());
    }

    protected boolean doShellScriptTests() {
        return true;
    }

    private void verifyError(List<String> stderr) throws DriverException {
        for (String line : stderr) {
            if (this.isExpectedError(line)) {
                this.feedback(line);
                continue;
            }
            throw new DriverException(stderr.toString());
        }
    }

    private boolean isExpectedError(String line) {
        boolean expected = false;
        if (line.startsWith("*sys-package-mgr*")) {
            expected = true;
        }
        return expected;
    }

    private void verifyOutput(List<String> stdout) throws DriverException {
        boolean started = false;
        for (String line : stdout) {
            if (this.isExpectedOutput(line)) {
                this.feedback(line);
                if (!line.startsWith(JYTHON_UP)) continue;
                started = true;
                continue;
            }
            throw new DriverException(stdout.toString());
        }
        if (!started) {
            throw new DriverException("start of jython failed:\n" + stdout.toString());
        }
    }

    private boolean isExpectedOutput(String line) {
        boolean expected = false;
        if (line.startsWith("[ChildProcess]") || line.startsWith(VERIFYING)) {
            expected = true;
        } else if (line.startsWith(JYTHON_UP)) {
            expected = true;
        }
        return expected;
    }

    private String getTestScript() {
        StringBuilder b = new StringBuilder(80);
        b.append("import sys\n");
        b.append("import os\n");
        b.append("print '");
        b.append(JYTHON_UP);
        b.append("'\n");
        return b.toString();
    }

    private void createTestScriptFile() throws DriverException {
        File file = new File(this.getTargetDir(), AUTOTEST_PY);
        try {
            FileHelper.write(file, this.getTestScript());
        }
        catch (IOException ioe) {
            throw new DriverException(ioe);
        }
    }

    private void feedback(String line) {
        System.out.println("feedback " + line);
    }
}

