/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.util.install.Installation;
import org.python.util.install.InstallerCommandLine;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.driver.Autotest;
import org.python.util.install.driver.ConsoleAutotest;
import org.python.util.install.driver.ConsoleDriver;
import org.python.util.install.driver.DriverException;
import org.python.util.install.driver.GuiAutotest;
import org.python.util.install.driver.NormalVerifier;
import org.python.util.install.driver.SilentAutotest;
import org.python.util.install.driver.StandaloneVerifier;
import org.python.util.install.driver.Tunnel;

public class InstallationDriver {
    private SilentAutotest[] _silentTests;
    private ConsoleAutotest[] _consoleTests;
    private GuiAutotest[] _guiTests;
    private InstallerCommandLine _commandLine;

    public InstallationDriver(InstallerCommandLine commandLine) throws DriverException {
        this._commandLine = commandLine;
        try {
            this.buildSilentTests();
            this.buildConsoleTests();
            this.buildGuiTests();
        }
        catch (IOException ioe) {
            throw new DriverException(ioe);
        }
    }

    public void drive() throws DriverException {
        try {
            int i;
            for (i = 0; i < this._silentTests.length; ++i) {
                this.driveSilentTest(this._silentTests[i]);
            }
            for (i = 0; i < this._consoleTests.length; ++i) {
                this.driveConsoleTest(this._consoleTests[i]);
            }
            for (i = 0; i < this._guiTests.length; ++i) {
                this.driveGuiTest(this._guiTests[i]);
            }
        }
        catch (IOException ioe) {
            throw new DriverException(ioe);
        }
    }

    private void driveConsoleTest(ConsoleAutotest consoleTest) throws DriverException, IOException {
        Tunnel _tunnel = new Tunnel();
        ConsoleDriver driver2 = new ConsoleDriver(_tunnel, consoleTest.getAnswers());
        driver2.start();
        Installation.driverMain(consoleTest.getCommandLineArgs(), consoleTest, _tunnel);
        _tunnel.close();
        this.validate(consoleTest);
    }

    private void driveSilentTest(SilentAutotest silentTest) throws DriverException {
        Installation.driverMain(silentTest.getCommandLineArgs(), silentTest, null);
        this.validate(silentTest);
    }

    private void driveGuiTest(GuiAutotest guiTest) throws DriverException {
        Installation.driverMain(guiTest.getCommandLineArgs(), guiTest, null);
        guiTest.execute();
        this.validate(guiTest);
    }

    private void validate(Autotest autoTest) throws DriverException {
        autoTest.assertTargetDirNotEmpty();
        if (autoTest.getVerifier() != null) {
            System.out.println("verifying installation - this can take a while ...");
            autoTest.getVerifier().verify();
            System.out.println("... installation ok.\n");
        }
    }

    private InstallerCommandLine getOriginalCommandLine() {
        return this._commandLine;
    }

    private void buildSilentTests() throws IOException, DriverException {
        ArrayList<SilentAutotest> silentTests = new ArrayList<SilentAutotest>(50);
        SilentAutotest test1 = new SilentAutotest(this.getOriginalCommandLine());
        String[] arguments2 = new String[]{"-s"};
        test1.setCommandLineArgs(arguments2);
        test1.addAdditionalArguments();
        test1.setVerifier(new NormalVerifier());
        silentTests.add(test1);
        SilentAutotest test2 = new SilentAutotest(this.getOriginalCommandLine());
        arguments2 = new String[]{"-s", "-t", "minimum"};
        test2.setCommandLineArgs(arguments2);
        test2.addAdditionalArguments();
        test2.setVerifier(new NormalVerifier());
        silentTests.add(test2);
        SilentAutotest test3 = new SilentAutotest(this.getOriginalCommandLine());
        arguments2 = new String[]{"-s", "-t", "standalone"};
        test3.setCommandLineArgs(arguments2);
        test3.addAdditionalArguments();
        test3.setVerifier(new StandaloneVerifier());
        silentTests.add(test3);
        int size = silentTests.size();
        this._silentTests = new SilentAutotest[size];
        Iterator silentIterator = silentTests.iterator();
        for (int i = 0; i < size; ++i) {
            this._silentTests[i] = (SilentAutotest)silentIterator.next();
        }
    }

    private void buildConsoleTests() throws IOException, DriverException {
        ArrayList<ConsoleAutotest> consoleTests = new ArrayList<ConsoleAutotest>(5);
        String[] arguments2 = this.getOriginalCommandLine().hasVerboseOption() ? new String[]{"-c", "-v"} : new String[]{"-c"};
        ConsoleAutotest test1 = new ConsoleAutotest(this.getOriginalCommandLine());
        test1.setCommandLineArgs(arguments2);
        test1.addAnswer("e");
        test1.addAnswer("n");
        test1.addAnswer("y");
        test1.addAnswer("3");
        test1.addAnswer("n");
        test1.addAnswer(test1.getTargetDir().getAbsolutePath());
        this.addJavaAndOSAnswers(test1);
        test1.addAnswer("y");
        test1.addAnswer("n");
        test1.setVerifier(new NormalVerifier());
        consoleTests.add(test1);
        ConsoleAutotest test2 = new ConsoleAutotest(this.getOriginalCommandLine());
        test2.setCommandLineArgs(arguments2);
        test2.addAnswer("e");
        test2.addAnswer("n");
        test2.addAnswer("y");
        test2.addAnswer("3");
        test2.addAnswer("y");
        test2.addAnswer("mod");
        test2.addAnswer("demo");
        test2.addAnswer("src");
        test2.addAnswer("n");
        test2.addAnswer("y");
        test2.addAnswer("demo");
        test2.addAnswer("wrongAnswer");
        test2.addAnswer("n");
        test2.addAnswer(test2.getTargetDir().getAbsolutePath());
        this.addJavaAndOSAnswers(test2);
        test2.addAnswer("y");
        test2.addAnswer("n");
        test2.setVerifier(new NormalVerifier());
        consoleTests.add(test2);
        ConsoleAutotest test3 = new ConsoleAutotest(this.getOriginalCommandLine());
        test3.setCommandLineArgs(arguments2);
        test3.addAnswer("e");
        test3.addAnswer("n");
        test3.addAnswer("y");
        test3.addAnswer("9");
        test3.addAnswer(test3.getTargetDir().getAbsolutePath());
        this.addJavaAndOSAnswers(test3);
        test3.addAnswer("y");
        test3.addAnswer("n");
        test3.setVerifier(new StandaloneVerifier());
        consoleTests.add(test3);
        ConsoleAutotest test4 = new ConsoleAutotest(this.getOriginalCommandLine());
        test4.setCommandLineArgs(arguments2);
        test4.addAnswer("e");
        test4.addAnswer("n");
        test4.addAnswer("y");
        test4.addAnswer("2");
        test4.addAnswer("n");
        test4.addAnswer("y");
        test4.addAnswer("n");
        test4.addAnswer(test4.getTargetDir().getAbsolutePath());
        this.addJavaAndOSAnswers(test4);
        test4.addAnswer("y");
        test4.addAnswer("n");
        test4.setVerifier(new NormalVerifier());
        consoleTests.add(test4);
        int size = consoleTests.size();
        this._consoleTests = new ConsoleAutotest[size];
        Iterator consoleIterator = consoleTests.iterator();
        for (int i = 0; i < size; ++i) {
            this._consoleTests[i] = (ConsoleAutotest)consoleIterator.next();
        }
    }

    private void addJavaAndOSAnswers(ConsoleAutotest test) {
        JavaHomeHandler javaHomeHandler = test.getJavaHomeHandler();
        if (javaHomeHandler.isDeviation() && javaHomeHandler.isValidHome()) {
            test.addAnswer(javaHomeHandler.getHome().getAbsolutePath());
        } else {
            test.addAnswer("=");
        }
        if (!Installation.isValidOs()) {
            test.addAnswer("");
        }
    }

    private void buildGuiTests() throws IOException, DriverException {
        ArrayList<GuiAutotest> guiTests = new ArrayList<GuiAutotest>(50);
        if (Installation.isGuiAllowed()) {
            GuiAutotest guiTest1 = new GuiAutotest(this.getOriginalCommandLine());
            this.buildLanguageAndLicensePage(guiTest1);
            guiTest1.addKeyAction(9);
            guiTest1.addKeyAction(9);
            guiTest1.addKeyAction(9);
            guiTest1.addKeyAction(9);
            guiTest1.addKeyAction(9);
            guiTest1.addKeyAction(9);
            guiTest1.addKeyAction(32);
            this.buildRestOfGuiPages(guiTest1);
            guiTest1.setVerifier(new NormalVerifier());
            guiTests.add(guiTest1);
            GuiAutotest guiTest2 = new GuiAutotest(this.getOriginalCommandLine());
            this.buildLanguageAndLicensePage(guiTest2);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(32);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(9);
            guiTest2.addKeyAction(32);
            this.buildRestOfGuiPages(guiTest2);
            guiTest2.setVerifier(new NormalVerifier());
            guiTests.add(guiTest2);
            GuiAutotest guiTest3 = new GuiAutotest(this.getOriginalCommandLine());
            this.buildLanguageAndLicensePage(guiTest3);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(32);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(32);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(32);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(32);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(9);
            guiTest3.addKeyAction(32);
            this.buildRestOfGuiPages(guiTest3);
            guiTest3.setVerifier(new NormalVerifier());
            guiTests.add(guiTest3);
            GuiAutotest guiTest4 = new GuiAutotest(this.getOriginalCommandLine());
            this.buildLanguageAndLicensePage(guiTest4);
            guiTest4.addKeyAction(9);
            guiTest4.addKeyAction(9);
            guiTest4.addKeyAction(32);
            guiTest4.addKeyAction(9);
            guiTest4.addKeyAction(9);
            guiTest4.addKeyAction(9);
            guiTest4.addKeyAction(9);
            guiTest4.addKeyAction(32);
            this.buildRestOfGuiPages(guiTest4);
            guiTest4.setVerifier(new StandaloneVerifier());
            guiTests.add(guiTest4);
        }
        int size = guiTests.size();
        this._guiTests = new GuiAutotest[size];
        Iterator guiIterator = guiTests.iterator();
        for (int i = 0; i < size; ++i) {
            this._guiTests[i] = (GuiAutotest)guiIterator.next();
        }
    }

    private void buildLanguageAndLicensePage(GuiAutotest guiTest) {
        guiTest.addKeyAction(69);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(32);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(32);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(32);
    }

    private void buildRestOfGuiPages(GuiAutotest guiTest) {
        boolean isValidDeviation;
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(32);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        guiTest.addKeyAction(9);
        JavaHomeHandler javaHomeHandler = guiTest.getJavaHomeHandler();
        boolean bl = isValidDeviation = javaHomeHandler.isDeviation() && javaHomeHandler.isValidHome();
        if (isValidDeviation) {
            guiTest.addKeyAction(9);
            guiTest.addKeyAction(9);
        }
        guiTest.addKeyAction(32);
        if (isValidDeviation) {
            guiTest.addKeyAction(32, 3000);
        } else {
            guiTest.addKeyAction(32);
        }
        guiTest.addWaitingKeyAction(9);
        guiTest.addKeyAction(32);
        guiTest.addKeyAction(32);
    }
}

