/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import org.python.util.install.AbstractWizard;
import org.python.util.install.DirectorySelectionPage;
import org.python.util.install.DirectorySelectionPageValidator;
import org.python.util.install.Installation;
import org.python.util.install.JarInfo;
import org.python.util.install.LanguagePage;
import org.python.util.install.LicensePage;
import org.python.util.install.LicensePageValidator;
import org.python.util.install.OverviewPage;
import org.python.util.install.ProgressPage;
import org.python.util.install.ReadmePage;
import org.python.util.install.SuccessPage;
import org.python.util.install.TextKeys;
import org.python.util.install.TypePage;
import org.python.util.install.ValidationEvent;
import org.python.util.install.ValidationException;
import org.python.util.install.ValidationInformationException;
import org.python.util.install.driver.Autotest;

public class Wizard
extends AbstractWizard
implements TextKeys {
    public Wizard(JarInfo jarInfo, Autotest autotest) {
        this.setTitle(this.getText("JYTHON_INSTALL"));
        LanguagePage languagePage = new LanguagePage(jarInfo);
        LicensePage licensePage = new LicensePage(jarInfo);
        licensePage.setValidator(new LicensePageValidator(licensePage));
        TypePage typePage = new TypePage();
        DirectorySelectionPage directoryPage = new DirectorySelectionPage(jarInfo);
        directoryPage.setValidator(new DirectorySelectionPageValidator(directoryPage));
        OverviewPage overviewPage = new OverviewPage();
        ProgressPage progressPage = new ProgressPage(jarInfo, autotest);
        ReadmePage readmePage = new ReadmePage(jarInfo);
        SuccessPage successPage = new SuccessPage(jarInfo);
        this.addPage(languagePage);
        this.addPage(licensePage);
        this.addPage(typePage);
        this.addPage(directoryPage);
        this.addPage(overviewPage);
        this.addPage(progressPage);
        this.addPage(readmePage);
        this.addPage(successPage);
        this.setSize(720, 540);
        this.centerOnScreen();
        this.validate();
    }

    @Override
    protected boolean finish() {
        return true;
    }

    @Override
    protected String getCancelString() {
        return this.getText("CANCEL");
    }

    @Override
    protected String getFinishString() {
        return this.getText("FINISH");
    }

    @Override
    protected String getNextString() {
        return this.getText("NEXT");
    }

    @Override
    protected String getPreviousString() {
        return this.getText("PREVIOUS");
    }

    @Override
    public void validationStarted(ValidationEvent event) {
    }

    @Override
    public void validationFailed(ValidationEvent event, ValidationException exception) {
        JOptionPane.showMessageDialog(this, exception.getMessage(), this.getText("ERROR"), 0);
    }

    @Override
    public void validationInformationRequired(ValidationEvent event, ValidationInformationException exception) {
        JOptionPane.showMessageDialog(this, exception.getMessage(), this.getText("INFORMATION"), 1);
    }

    @Override
    public void validationSucceeded(ValidationEvent event) {
    }

    private final String getText(String textKey) {
        return Installation.getText(textKey);
    }

    private void centerOnScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle rectBounds = this.getBounds();
        this.setLocation((dim.width - rectBounds.width) / 2, (dim.height - rectBounds.height) / 2);
    }
}

