/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.FrameInstaller;
import org.python.util.install.JarInfo;

public class LicensePage
extends AbstractWizardPage {
    private static final String _ACCEPT_ACTION_COMMAND = "1";
    private static final String _DO_NOT_ACCEPT_ACTION_COMMAND = "0";
    private JRadioButton _acceptButton;
    private JRadioButton _doNotAcceptButton;

    public LicensePage(JarInfo jarInfo) {
        this.initComponents(jarInfo);
    }

    private void initComponents(JarInfo jarInfo) {
        String licenseText = "n/a";
        try {
            licenseText = jarInfo.getLicenseText();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(1, 1, 10, 10));
        JTextArea textArea = new JTextArea(13, 80);
        JScrollPane scrollPane = new JScrollPane(textArea, 22, 32);
        textArea.setEditable(false);
        textArea.setText(licenseText);
        centerPanel.add(scrollPane);
        JPanel southPanel = new JPanel();
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        this._acceptButton = new JRadioButton();
        this._acceptButton.setActionCommand(_ACCEPT_ACTION_COMMAND);
        this._acceptButton.addActionListener(radioButtonListener);
        this._doNotAcceptButton = new JRadioButton();
        this._doNotAcceptButton.setActionCommand(_DO_NOT_ACCEPT_ACTION_COMMAND);
        this._doNotAcceptButton.addActionListener(radioButtonListener);
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(this._acceptButton);
        radioButtonGroup.add(this._doNotAcceptButton);
        JPanel radioPanel = new JPanel(new GridLayout(1, 0));
        radioPanel.add(this._acceptButton);
        radioPanel.add(this._doNotAcceptButton);
        southPanel.add(radioPanel);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)centerPanel, "Center");
        this.add((Component)southPanel, "South");
    }

    @Override
    protected String getTitle() {
        return this.getText("LICENSE");
    }

    @Override
    protected String getDescription() {
        return this.getText("PLEASE_READ_LICENSE");
    }

    @Override
    protected boolean isCancelVisible() {
        return true;
    }

    @Override
    protected boolean isPreviousVisible() {
        return true;
    }

    @Override
    protected boolean isNextVisible() {
        return true;
    }

    @Override
    protected JComponent getFocusField() {
        return this._doNotAcceptButton;
    }

    @Override
    protected void activate() {
        this._acceptButton.setText(this.getText("ACCEPT"));
        this._doNotAcceptButton.setText(this.getText("DO_NOT_ACCEPT"));
        boolean accept = FrameInstaller.isAccept();
        this._acceptButton.setSelected(accept);
        this._doNotAcceptButton.setSelected(!accept);
    }

    @Override
    protected void passivate() {
    }

    @Override
    protected void beforeValidate() {
    }

    protected boolean isAccept() {
        return this._acceptButton.isSelected() && !this._doNotAcceptButton.isSelected();
    }

    private static final class RadioButtonListener
    implements ActionListener {
        private RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals(LicensePage._ACCEPT_ACTION_COMMAND)) {
                FrameInstaller.setAccept(true);
            } else {
                FrameInstaller.setAccept(false);
            }
        }
    }
}

