/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import org.python.util.install.AbstractWizardValidator;
import org.python.util.install.FrameInstaller;
import org.python.util.install.Installation;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.JavaSelectionPage;
import org.python.util.install.ValidationException;

public class JavaSelectionPageValidator
extends AbstractWizardValidator {
    JavaSelectionPage _page;

    JavaSelectionPageValidator(JavaSelectionPage page) {
        this._page = page;
    }

    @Override
    protected void validate() throws ValidationException {
        Installation.JavaVersionInfo javaVersionInfo = new Installation.JavaVersionInfo();
        String directory = this._page.getJavaHome().getText().trim();
        JavaHomeHandler javaHomeHandler = new JavaHomeHandler(directory);
        if (javaHomeHandler.isDeviation()) {
            javaVersionInfo = Installation.getExternalJavaVersion(javaHomeHandler);
            if (javaVersionInfo.getErrorCode() != 0) {
                throw new ValidationException(javaVersionInfo.getReason());
            }
        } else {
            Installation.fillJavaVersionInfo(javaVersionInfo, System.getProperties());
        }
        FrameInstaller.setJavaHomeHandler(javaHomeHandler);
        FrameInstaller.setJavaVersionInfo(javaVersionInfo);
    }
}

