/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.util.install.ChildProcess;
import org.python.util.install.ConsoleInstaller;
import org.python.util.install.Installation;
import org.python.util.install.InstallationListener;
import org.python.util.install.InstallationType;
import org.python.util.install.InstallerException;
import org.python.util.install.JarInfo;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.ProgressListener;
import org.python.util.install.StandalonePackager;
import org.python.util.install.StartScriptGenerator;

public class JarInstaller {
    public static final String JYTHON_JAR = "jython.jar";
    private static final String PATH_SEPARATOR = "/";
    private static final String LIB_NAME_SEP = "Lib/";
    private static final String LIB_PAWT_SEP = "Lib/pawt/";
    private static final int BUFFER_SIZE = 1024;
    private ProgressListener _progressListener;
    private JarInfo _jarInfo;
    private List<InstallationListener> _installationListeners;

    public JarInstaller(ProgressListener progressListener, JarInfo jarInfo) {
        this._progressListener = progressListener;
        this._jarInfo = jarInfo;
        this._installationListeners = new ArrayList<InstallationListener>();
    }

    public void inflate(File targetDirectory, InstallationType installationType, JavaHomeHandler javaHomeHandler) {
        try {
            List<String> excludeDirs = this._jarInfo.getExcludeDirs();
            ArrayList<String> coreLibFiles = new ArrayList();
            if (!installationType.installSources()) {
                excludeDirs.add("src");
                excludeDirs.add("grammar");
                excludeDirs.add("extlibs");
            }
            if (!installationType.installDocumentation()) {
                excludeDirs.add("Doc");
            }
            if (!installationType.installDemosAndExamples()) {
                excludeDirs.add("Demo");
            }
            if (!installationType.installLibraryModules()) {
                excludeDirs.add("Lib/email");
                excludeDirs.add("Lib/encodings");
                excludeDirs.add("Lib/test");
                excludeDirs.add("Lib/jxxload_help");
                coreLibFiles = this.getCoreLibFiles();
            }
            if (installationType.isStandalone()) {
                excludeDirs.add("Tools");
            }
            int count2 = 0;
            int percent = 0;
            int numberOfIntervals = 100 / this._progressListener.getInterval();
            int numberOfEntries = this.approximateNumberOfEntries(installationType);
            int threshold = numberOfEntries / numberOfIntervals + 1;
            boolean coreExclusionReported = false;
            ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this._jarInfo.getJarFile()), 1024));
            ZipEntry zipEntry = zipInput.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                boolean exclude = false;
                Iterator<String> excludeDirsAsIterator = excludeDirs.iterator();
                while (excludeDirsAsIterator.hasNext()) {
                    if (!zipEntryName.startsWith(excludeDirsAsIterator.next() + PATH_SEPARATOR)) continue;
                    exclude = true;
                }
                if (!installationType.installSources() && zipEntryName.equals("build.xml")) {
                    exclude = true;
                }
                if (!exclude) {
                    exclude = this.shouldExcludeFile(installationType, coreLibFiles, zipEntry, zipEntryName);
                    if (Installation.isVerbose() && !coreExclusionReported && exclude) {
                        ConsoleInstaller.message("excluding some .py files, like " + zipEntryName);
                        coreExclusionReported = true;
                    }
                }
                if (exclude) {
                    if (Installation.isVerbose() && zipEntry.isDirectory()) {
                        ConsoleInstaller.message("excluding directory " + zipEntryName);
                    }
                } else {
                    if (++count2 % threshold == 0) {
                        this._progressListener.progressChanged(percent += this._progressListener.getInterval());
                    }
                    this.createDirectories(targetDirectory, zipEntryName);
                    if (!zipEntry.isDirectory()) {
                        int len;
                        File file = this.createFile(targetDirectory, zipEntryName);
                        this._progressListener.progressEntry(file.getAbsolutePath());
                        FileOutputStream output = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        while ((len = zipInput.read(buffer)) > 0) {
                            output.write(buffer, 0, len);
                        }
                        output.close();
                        file.setLastModified(zipEntry.getTime());
                    }
                }
                zipInput.closeEntry();
                zipEntry = zipInput.getNextEntry();
            }
            if (!installationType.isStandalone()) {
                this._progressListener.progressStartScripts();
                StartScriptGenerator generator2 = new StartScriptGenerator(targetDirectory, javaHomeHandler);
                generator2.generateStartScripts();
                if (installationType.ensurepip()) {
                    this._progressListener.progressEnsurepip();
                    this._progressListener.progressChanged(90);
                    this.ensurepip(targetDirectory.toPath().resolve("bin"));
                }
            } else {
                this._progressListener.progressStandalone();
                File jythonJar = new File(targetDirectory, JYTHON_JAR);
                File jythonPlainJar = new File(targetDirectory, "plain_jython.jar");
                jythonJar.renameTo(jythonPlainJar);
                File libDir = new File(targetDirectory, "Lib");
                StandalonePackager packager = new StandalonePackager(jythonJar);
                packager.addJarFile(jythonPlainJar);
                this._progressListener.progressChanged(90);
                packager.addFullDirectory(libDir);
                packager.close();
                StandalonePackager.emptyDirectory(targetDirectory, jythonJar);
            }
            this._progressListener.progressFinished();
            Iterator<InstallationListener> installationListenersIterator = this._installationListeners.iterator();
            while (installationListenersIterator.hasNext()) {
                installationListenersIterator.next().progressFinished();
            }
        }
        catch (IOException ioe) {
            throw new InstallerException(Installation.getText("ERROR_ACCESS_JARFILE"), ioe);
        }
    }

    private int ensurepip(Path bindir) {
        int errorCode = 0;
        try {
            String[] command = Installation.isWindows() ? new String[]{bindir.resolve("jython.exe").toString(), "-m", "ensurepip"} : new String[]{Paths.get(".", "jython").toString(), "-m", "ensurepip"};
            ChildProcess childProcess = new ChildProcess(command);
            childProcess.setCWD(bindir);
            childProcess.putEnvironment("JYTHON_HOME", null);
            errorCode = childProcess.run();
        }
        catch (Throwable t) {
            errorCode = 1;
        }
        return errorCode;
    }

    public void addInstallationListener(InstallationListener installationListener) {
        if (installationListener != null) {
            this._installationListeners.add(installationListener);
        }
    }

    private int approximateNumberOfEntries(InstallationType installationType) {
        int numberOfEntries = 200;
        if (installationType.installLibraryModules()) {
            numberOfEntries = installationType.isStandalone() ? (numberOfEntries += 450) : (numberOfEntries += 1300);
        }
        if (installationType.installDemosAndExamples()) {
            numberOfEntries += 70;
        }
        if (installationType.installDocumentation()) {
            numberOfEntries += 500;
        }
        if (installationType.installSources()) {
            numberOfEntries += 1000;
        }
        if (installationType.ensurepip()) {
            numberOfEntries += 2000;
        }
        return numberOfEntries;
    }

    private void createDirectories(File targetDirectory, String zipEntryName) {
        File directory;
        int lastSepIndex = zipEntryName.lastIndexOf(PATH_SEPARATOR);
        if (!(lastSepIndex <= 0 || (directory = new File(targetDirectory, zipEntryName.substring(0, lastSepIndex))).exists() && directory.isDirectory() || directory.mkdirs())) {
            throw new InstallerException(Installation.getText("UNABLE_CREATE_DIRECTORY", directory.getAbsolutePath()));
        }
    }

    private File createFile(File targetDirectory, String zipEntryName) throws IOException {
        File file = new File(targetDirectory, zipEntryName);
        if (!(file.exists() && file.isFile() || file.createNewFile())) {
            throw new InstallerException(Installation.getText("UNABLE_CREATE_FILE", file.getCanonicalPath()));
        }
        return file;
    }

    private List<String> getCoreLibFiles() {
        ArrayList<String> coreLibFiles = new ArrayList<String>();
        coreLibFiles.add("__future__.py");
        coreLibFiles.add("copy.py");
        coreLibFiles.add("copy_reg.py");
        coreLibFiles.add("dbexts.py");
        coreLibFiles.add("imaplib.py");
        coreLibFiles.add("isql.py");
        coreLibFiles.add("javaos.py");
        coreLibFiles.add("javapath.py");
        coreLibFiles.add("jreload.py");
        coreLibFiles.add("linecache.py");
        coreLibFiles.add("marshal.py");
        coreLibFiles.add("ntpath.py");
        coreLibFiles.add("os.py");
        coreLibFiles.add("popen2.py");
        coreLibFiles.add("posixpath.py");
        coreLibFiles.add("random.py");
        coreLibFiles.add("re.py");
        coreLibFiles.add("site.py");
        coreLibFiles.add("socket.py");
        coreLibFiles.add("sre.py");
        coreLibFiles.add("sre_compile.py");
        coreLibFiles.add("sre_constants.py");
        coreLibFiles.add("sre_parse.py");
        coreLibFiles.add("stat.py");
        coreLibFiles.add("string.py");
        coreLibFiles.add("sysconfig.py");
        coreLibFiles.add("threading.py");
        coreLibFiles.add("traceback.py");
        coreLibFiles.add("types.py");
        coreLibFiles.add("UserDict.py");
        coreLibFiles.add("zipfile.py");
        coreLibFiles.add("zlib.py");
        return coreLibFiles;
    }

    private boolean shouldExcludeFile(InstallationType installationType, List<String> coreLibFiles, ZipEntry zipEntry, String zipEntryName) {
        boolean exclude = false;
        if (!installationType.installLibraryModules() && !zipEntry.isDirectory() && zipEntryName.startsWith(LIB_NAME_SEP) && !zipEntryName.startsWith(LIB_PAWT_SEP) && zipEntryName.endsWith(".py")) {
            exclude = true;
            for (String coreFileName : coreLibFiles) {
                if (!zipEntryName.endsWith(PATH_SEPARATOR + coreFileName)) continue;
                exclude = false;
            }
        }
        return exclude;
    }
}

