/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.python.util.install.Installation;
import org.python.util.install.InstallerException;

public class JarInfo {
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_SEPARATOR = "!";
    private static final String JYTHON = "Jython";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String EXCLUDE_DIRS_ATTRIBUTE = "exclude-dirs";
    private static final String EXCLUDE_DIRS_DELIM = ";";
    private File _jarFile = null;
    private int _numberOfEntries = 0;
    private Manifest _manifest = null;
    private String _licenseText;
    private String _readmeText;

    public JarInfo() {
        try {
            this.readJarInfo();
        }
        catch (IOException ioe) {
            throw new InstallerException(Installation.getText("ERROR_ACCESS_JARFILE"), ioe);
        }
    }

    public String getVersion() {
        String version2 = "<unknown>";
        try {
            Attributes jythonAttributes = this.getManifest().getAttributes(JYTHON);
            if (jythonAttributes != null) {
                version2 = jythonAttributes.getValue(VERSION_ATTRIBUTE);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version2;
    }

    public File getJarFile() throws IOException {
        if (this._jarFile == null) {
            this.readJarInfo();
        }
        return this._jarFile;
    }

    public Manifest getManifest() throws IOException {
        if (this._manifest == null) {
            this.readJarInfo();
        }
        return this._manifest;
    }

    public int getNumberOfEntries() throws IOException {
        if (this._numberOfEntries == 0) {
            this.readJarInfo();
        }
        return this._numberOfEntries;
    }

    public List<String> getExcludeDirs() throws IOException {
        String excludeDirsString;
        ArrayList<String> excludeDirs = new ArrayList<String>();
        Attributes jythonAttributes = this.getManifest().getAttributes(JYTHON);
        if (jythonAttributes != null && (excludeDirsString = jythonAttributes.getValue(EXCLUDE_DIRS_ATTRIBUTE)) != null && excludeDirsString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(excludeDirsString, EXCLUDE_DIRS_DELIM);
            while (tokenizer.hasMoreTokens()) {
                excludeDirs.add(tokenizer.nextToken());
            }
        }
        return excludeDirs;
    }

    public String getLicenseText() throws IOException {
        if (this._licenseText == null) {
            this.readJarInfo();
        }
        return this._licenseText;
    }

    public String getReadmeText() throws IOException {
        if (this._readmeText == null) {
            this.readJarInfo();
        }
        return this._readmeText;
    }

    private void readJarInfo() throws IOException {
        String fullClassName = this.getClass().getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        URL url = this.getClass().getResource(className + ".class");
        String plus = "\\+";
        String escapedPlus = "__ppluss__";
        String rawUrl = url.toString();
        rawUrl = rawUrl.replaceAll("\\+", "__ppluss__");
        String urlString = URLDecoder.decode(rawUrl, "UTF-8");
        urlString = urlString.replaceAll("__ppluss__", "\\+");
        int jarSeparatorIndex = urlString.lastIndexOf(JAR_SEPARATOR);
        if (!urlString.startsWith(JAR_URL_PREFIX) || jarSeparatorIndex <= 0) {
            throw new InstallerException(Installation.getText("UNEXPECTED_URL", urlString));
        }
        String jarFileName = urlString.substring(JAR_URL_PREFIX.length(), jarSeparatorIndex);
        this._jarFile = new File(jarFileName);
        if (!this._jarFile.exists()) {
            throw new InstallerException(Installation.getText("JAR_NOT_FOUND", this._jarFile.getAbsolutePath()));
        }
        JarFile jarFile = new JarFile(this._jarFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        this._numberOfEntries = 0;
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if ("LICENSE.txt".equals(entry.getName())) {
                this._licenseText = this.readTextFile(entry, jarFile);
            }
            if ("README.txt".equals(entry.getName())) {
                this._readmeText = this.readTextFile(entry, jarFile);
            }
            ++this._numberOfEntries;
        }
        this._manifest = jarFile.getManifest();
        if (this._manifest == null) {
            throw new InstallerException(Installation.getText("NO_MANIFEST", this._jarFile.getAbsolutePath()));
        }
        jarFile.close();
    }

    private String readTextFile(JarEntry entry, JarFile jarFile) throws IOException {
        String contents = this.readTextFileWithCharset(jarFile, entry, "US-ASCII");
        if (contents == null) {
            contents = this.readTextFileWithCharset(jarFile, entry, "ISO-8859-1");
        }
        if (contents == null) {
            contents = this.readTextFileWithDefaultCharset(jarFile, entry);
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextFileWithCharset(JarFile jarFile, JarEntry entry, String charsetName) {
        String contents = null;
        if (Charset.isSupported(charsetName)) {
            BufferedReader reader = null;
            try {
                String s;
                StringBuffer buffer = new StringBuffer(1000);
                reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry), Charset.forName(charsetName)));
                buffer = new StringBuffer(1000);
                while ((s = reader.readLine()) != null) {
                    buffer.append(s);
                    buffer.append("\n");
                }
                contents = buffer.toString();
            }
            catch (IOException iOException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextFileWithDefaultCharset(JarFile jarFile, JarEntry entry) throws IOException {
        String contents = null;
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
            StringBuffer buffer = new StringBuffer(1000);
            while ((s = reader.readLine()) != null) {
                buffer.append(s);
                buffer.append("\n");
            }
            contents = buffer.toString();
        }
        return contents;
    }
}

