/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.commons.cli.PosixParser;
import org.python.util.install.ConsoleInstaller;
import org.python.util.install.Installation;
import org.python.util.install.InstallationType;
import org.python.util.install.JarInfo;
import org.python.util.install.JavaHomeHandler;

public class InstallerCommandLine {
    protected static final String INEXCLUDE_LIBRARY_MODULES = "mod";
    protected static final String INEXCLUDE_DEMOS_AND_EXAMPLES = "demo";
    protected static final String INEXCLUDE_DOCUMENTATION = "doc";
    protected static final String INEXCLUDE_SOURCES = "src";
    protected static final String INEXCLUDE_ENSUREPIP = "ensurepip";
    protected static final String CONSOLE_SHORT = "c";
    protected static final String CONSOLE_LONG = "console";
    private static final String CONSOLE_DESC = "console based installation (user interaction)\nany other options will be ignored (except 'verbose')";
    protected static final String SILENT_SHORT = "s";
    protected static final String SILENT_LONG = "silent";
    private static final String SILENT_DESC = "silent installation (without user interaction)";
    protected static final String VERBOSE_SHORT = "v";
    protected static final String VERBOSE_LONG = "verbose";
    private static final String VERBOSE_DESC = "print more output during the installation\n(also valid in GUI and autotest mode)";
    private static final String AUTOTEST_SHORT = "A";
    private static final String AUTOTEST_LONG = "autotest";
    private static final String AUTOTEST_DESC = "automatic stress tests for the installer\nmost of the other options are ignored\nallowed additional options: 'verbose";
    private static final String DIRECTORY_SHORT = "d";
    private static final String DIRECTORY_LONG = "directory";
    private static final String DIRECTORY_DESC = "target directory to install to\n(required in silent mode,\nused as default in GUI mode)";
    private static final String DIRECTORY_ARG = "dir";
    private static final String TYPE_STANDARD = "standard";
    private static final String TYPE_ALL = "all";
    private static final String TYPE_MINIMUM = "minimum";
    protected static final String TYPE_STANDALONE = "standalone";
    private static final String STANDALONE_DOCUMENTATION = "install a single, executable .jar,\ncontaining all the modules";
    private static final String INEXCLUDE_ARG = "part(s)";
    private static final String INEXCLUDE_PARTS = "more than one of the following is possible:\n- mod: library modules\n- demo: demos and examples\n- doc: documentation\n- src: java source code\n- ensurepip: install pip and setuptools";
    private static final String TYPE_SHORT = "t";
    private static final String TYPE_LONG = "type";
    private static final String TYPE_ARG = "type";
    private static final String TYPE_DESC = "installation type\none of the following types is possible\n(see also include/exclude parts):\n- all: everything (including src)\n- standard: core, mod, demo, doc, ensurepip\nstandard is the default\n- minimum: core\n- standalone: install a single, executable .jar,\ncontaining all the modules";
    private static final String INCLUDE_SHORT = "i";
    private static final String INCLUDE_LONG = "include";
    private static final String INCLUDE_DESC = "finer control over parts to install\nmore than one of the following is possible:\n- mod: library modules\n- demo: demos and examples\n- doc: documentation\n- src: java source code\n- ensurepip: install pip and setuptools";
    private static final String EXCLUDE_SHORT = "e";
    private static final String EXCLUDE_LONG = "exclude";
    private static final String EXCLUDE_DESC = "finer control over parts not to install\nmore than one of the following is possible:\n- mod: library modules\n- demo: demos and examples\n- doc: documentation\n- src: java source code\n- ensurepip: install pip and setuptools\n(excludes override includes)";
    private static final String HELP_SHORT = "h";
    private static final String HELP2_SHORT = "?";
    private static final String HELP_LONG = "help";
    private static final String HELP_DESC = "print this help (overrides any other options)";
    private static final String SYNTAX = "\n\tjava -jar jython_version.jar";
    private static final String HEADER = "\nNo option at all will start the interactive GUI installer, except:\nOptions respected in GUI mode are 'directory', which serve as default values in the wizard.\nIn non-GUI mode the following options are available:\n";
    private static final String SYNTAX_WITHOUT_JAR = "\n\tjava -jar ";
    private static final String FOOTER = "";
    private static final String EXAMPLES = "\nexample of a GUI installation:{0}\n\nexample of a console installation:{0} -c\n\nexample of a silent installation:{0} -s -d targetDirectory\n\nexamples of a silent installation with more options:{0} -s -d targetDirectory -t minimum -i src{0} -s -d targetDirectory -t standard -e demo doc -i src\n\nexample of an autotest installation into temporary directories:{0} -A\n\t(uses java.awt.Robot; make sure you do NOT touch mouse NOR keyboard\n\t after hitting enter/return!)";
    private String[] _args;
    private Options _options;
    private CommandLine _commandLine;
    private JarInfo _jarInfo;
    private final Parser _parser = new PosixParser();

    public InstallerCommandLine(JarInfo jarInfo) {
        this.createOptions();
        this._jarInfo = jarInfo;
    }

    public static final boolean hasVerboseOptionInArgs(String[] args) {
        String shortVerbose = "-".concat(VERBOSE_SHORT);
        String longVerbose = "--".concat(VERBOSE_LONG);
        return InstallerCommandLine.hasOptionInArgs(args, shortVerbose, longVerbose);
    }

    public InstallerCommandLine() {
        this(null);
    }

    public boolean setArgs(String[] args) {
        int i;
        String type;
        try {
            CommandLine preCommandLine = this._parser.parse(this._options, args, false);
            if (!(this.hasConsoleOption(preCommandLine) || this.hasSilentOption(preCommandLine) || this.hasAutotestOption(preCommandLine) || Installation.isGuiAllowed() && !Installation.isGNUJava())) {
                if (this.hasVerboseOption(preCommandLine)) {
                    ConsoleInstaller.message("auto-switching to console mode");
                }
                String[] newArgs = new String[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[args.length] = "-c";
                args = newArgs;
            }
        }
        catch (Exception preCommandLine) {
            // empty catch block
        }
        this._args = args;
        try {
            this._commandLine = this._parser.parse(this._options, this._args, false);
        }
        catch (MissingArgumentException mae) {
            System.err.println(mae.getMessage());
            return false;
        }
        catch (ParseException pe) {
            System.err.println(pe.getMessage());
            return false;
        }
        List unrecognized = this._commandLine.getArgList();
        if (unrecognized.size() > 0) {
            System.err.println("unrecognized argument(s): " + unrecognized);
            return false;
        }
        if (!(!this.hasTypeOption() || TYPE_ALL.equals(type = this._commandLine.getOptionValue(TYPE_SHORT)) || TYPE_STANDARD.equals(type) || TYPE_MINIMUM.equals(type) || TYPE_STANDALONE.equals(type))) {
            System.err.println("unrecognized argument '" + type + "' to option: " + TYPE_SHORT + " / " + "type");
            return false;
        }
        if (this.hasSilentOption() && !this.hasDirectoryOption()) {
            System.err.println("option d / directory is required in silent mode");
            return false;
        }
        if (this.hasIncludeOption()) {
            String[] includeParts = this._commandLine.getOptionValues(INCLUDE_SHORT);
            for (i = 0; i < includeParts.length; ++i) {
                if (this.isValidInExcludePart(includeParts[i])) continue;
                System.err.println("unrecognized include part '" + includeParts[i] + "'");
                return false;
            }
        }
        if (this.hasExcludeOption()) {
            String[] excludeParts = this._commandLine.getOptionValues(EXCLUDE_SHORT);
            for (i = 0; i < excludeParts.length; ++i) {
                if (this.isValidInExcludePart(excludeParts[i])) continue;
                System.err.println("unrecognized exclude part '" + excludeParts[i] + "'");
                return false;
            }
        }
        return true;
    }

    public boolean hasArguments() {
        return this._args.length > 0;
    }

    public boolean hasHelpOption() {
        return this._commandLine.hasOption(HELP_SHORT) || this._commandLine.hasOption(HELP2_SHORT) || this._commandLine.hasOption(HELP_LONG);
    }

    public boolean hasSilentOption() {
        return this.hasSilentOption(this._commandLine);
    }

    private boolean hasSilentOption(CommandLine commandLine) {
        return commandLine.hasOption(SILENT_SHORT) || commandLine.hasOption(SILENT_LONG);
    }

    public boolean hasConsoleOption() {
        return this.hasConsoleOption(this._commandLine);
    }

    private boolean hasConsoleOption(CommandLine commandLine) {
        return commandLine.hasOption(CONSOLE_SHORT) || commandLine.hasOption(CONSOLE_LONG);
    }

    public boolean hasAutotestOption() {
        return this.hasAutotestOption(this._commandLine);
    }

    private boolean hasAutotestOption(CommandLine commandLine) {
        return commandLine.hasOption(AUTOTEST_SHORT) || commandLine.hasOption(AUTOTEST_LONG);
    }

    public boolean hasDirectoryOption() {
        return this._commandLine.hasOption(DIRECTORY_SHORT) || this._commandLine.hasOption(DIRECTORY_LONG);
    }

    public boolean hasTypeOption() {
        return this._commandLine.hasOption(TYPE_SHORT) || this._commandLine.hasOption("type");
    }

    public boolean hasIncludeOption() {
        return this._commandLine.hasOption(INCLUDE_SHORT) || this._commandLine.hasOption(INCLUDE_LONG);
    }

    public boolean hasExcludeOption() {
        return this._commandLine.hasOption(EXCLUDE_SHORT) || this._commandLine.hasOption(EXCLUDE_LONG);
    }

    public boolean hasVerboseOption() {
        return this.hasVerboseOption(this._commandLine);
    }

    private boolean hasVerboseOption(CommandLine commandLine) {
        return commandLine.hasOption(VERBOSE_SHORT) || commandLine.hasOption(VERBOSE_LONG);
    }

    public void printHelp() {
        HelpFormatter formatter2 = new HelpFormatter();
        formatter2.defaultWidth = 76;
        String syntax2 = SYNTAX;
        if (this._jarInfo != null) {
            try {
                syntax2 = SYNTAX_WITHOUT_JAR + this._jarInfo.getJarFile().getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        formatter2.printHelp(syntax2, HEADER, this._options, FOOTER, true);
        String examples = MessageFormat.format(EXAMPLES, syntax2);
        System.out.println(examples);
    }

    public File getTargetDirectory() {
        if (this.hasDirectoryOption()) {
            return new File(this._commandLine.getOptionValue(DIRECTORY_SHORT));
        }
        return null;
    }

    public JavaHomeHandler getJavaHomeHandler() {
        return new JavaHomeHandler();
    }

    public InstallationType getInstallationType() {
        int i;
        InstallationType installationType = new InstallationType();
        if (this.hasTypeOption()) {
            String typeName = this._commandLine.getOptionValue(TYPE_SHORT);
            if (TYPE_ALL.equals(typeName)) {
                installationType.setAll();
            } else if (TYPE_MINIMUM.equals(typeName)) {
                installationType.setMinimum();
            } else if (TYPE_STANDALONE.equals(typeName)) {
                installationType.setStandalone();
            }
        }
        if (this.hasIncludeOption()) {
            String[] includeParts = this._commandLine.getOptionValues(INCLUDE_SHORT);
            for (i = 0; i < includeParts.length; ++i) {
                if (INEXCLUDE_DEMOS_AND_EXAMPLES.equals(includeParts[i])) {
                    installationType.addDemosAndExamples();
                }
                if (INEXCLUDE_DOCUMENTATION.equals(includeParts[i])) {
                    installationType.addDocumentation();
                }
                if (INEXCLUDE_LIBRARY_MODULES.equals(includeParts[i])) {
                    installationType.addLibraryModules();
                }
                if (INEXCLUDE_SOURCES.equals(includeParts[i])) {
                    installationType.addSources();
                }
                if (!INEXCLUDE_ENSUREPIP.equals(includeParts[i])) continue;
                installationType.addEnsurepip();
            }
        }
        if (this.hasExcludeOption()) {
            String[] excludeParts = this._commandLine.getOptionValues(EXCLUDE_SHORT);
            for (i = 0; i < excludeParts.length; ++i) {
                if (INEXCLUDE_DEMOS_AND_EXAMPLES.equals(excludeParts[i])) {
                    installationType.removeDemosAndExamples();
                }
                if (INEXCLUDE_DOCUMENTATION.equals(excludeParts[i])) {
                    installationType.removeDocumentation();
                }
                if (INEXCLUDE_LIBRARY_MODULES.equals(excludeParts[i])) {
                    installationType.removeLibraryModules();
                }
                if (INEXCLUDE_SOURCES.equals(excludeParts[i])) {
                    installationType.removeSources();
                }
                if (!INEXCLUDE_ENSUREPIP.equals(excludeParts[i])) continue;
                installationType.removeEnsurepip();
            }
        }
        return installationType;
    }

    private static final boolean hasOptionInArgs(String[] args, String shortOption, String longOption) {
        boolean hasOption = false;
        for (int i = 0; !hasOption && i < args.length; ++i) {
            if (!shortOption.equals(args[i]) && !longOption.equals(args[i])) continue;
            hasOption = true;
        }
        return hasOption;
    }

    private void createOptions() {
        this._options = new Options();
        this._options.setSortAsAdded(true);
        Option consoleOption = new Option(CONSOLE_SHORT, CONSOLE_LONG, false, CONSOLE_DESC);
        Option silentOption = new Option(SILENT_SHORT, SILENT_LONG, false, SILENT_DESC);
        Option autotestOption = new Option(AUTOTEST_SHORT, AUTOTEST_LONG, false, AUTOTEST_DESC);
        OptionGroup group1 = new OptionGroup();
        group1.addOption(consoleOption);
        group1.addOption(silentOption);
        group1.addOption(autotestOption);
        this._options.addOptionGroup(group1);
        Option directoryOption = new Option(DIRECTORY_SHORT, DIRECTORY_LONG, true, DIRECTORY_DESC);
        directoryOption.setArgName(DIRECTORY_ARG);
        this._options.addOption(directoryOption);
        Option typeOption = new Option(TYPE_SHORT, "type", true, TYPE_DESC);
        typeOption.setArgName("type");
        this._options.addOption(typeOption);
        Option includeOption = new Option(INCLUDE_SHORT, INCLUDE_DESC);
        includeOption.setArgs(4);
        includeOption.setArgName(INEXCLUDE_ARG);
        includeOption.setLongOpt(INCLUDE_LONG);
        this._options.addOption(includeOption);
        Option excludeOption = new Option(EXCLUDE_SHORT, EXCLUDE_DESC);
        excludeOption.setArgs(4);
        excludeOption.setArgName(INEXCLUDE_ARG);
        excludeOption.setLongOpt(EXCLUDE_LONG);
        this._options.addOption(excludeOption);
        Option verboseOption = new Option(VERBOSE_SHORT, VERBOSE_LONG, false, VERBOSE_DESC);
        this._options.addOption(verboseOption);
        Option helpHOption = new Option(HELP_SHORT, HELP_LONG, false, HELP_DESC);
        Option helpQOption = new Option(HELP2_SHORT, HELP_DESC);
        OptionGroup group2 = new OptionGroup();
        group2.addOption(helpHOption);
        group2.addOption(helpQOption);
        this._options.addOptionGroup(group2);
    }

    private boolean isValidInExcludePart(String part) {
        return INEXCLUDE_DEMOS_AND_EXAMPLES.equals(part) || INEXCLUDE_DOCUMENTATION.equals(part) || INEXCLUDE_LIBRARY_MODULES.equals(part) || INEXCLUDE_SOURCES.equals(part) || INEXCLUDE_ENSUREPIP.equals(part);
    }
}

