/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.python.util.install.ChildProcess;
import org.python.util.install.ConsoleInstaller;
import org.python.util.install.FileHelper;
import org.python.util.install.FrameInstaller;
import org.python.util.install.InstallationCancelledException;
import org.python.util.install.InstallerCommandLine;
import org.python.util.install.JarInfo;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.JavaVersionTester;
import org.python.util.install.driver.Autotest;
import org.python.util.install.driver.InstallationDriver;
import org.python.util.install.driver.Tunnel;

public class Installation {
    public static final int NORMAL_RETURN = 0;
    public static final int ERROR_RETURN = 1;
    protected static final String ALL = "1";
    protected static final String STANDARD = "2";
    protected static final String MINIMUM = "3";
    protected static final String STANDALONE = "9";
    protected static final String OS_NAME = "os.name";
    protected static final String OS_VERSION = "os.version";
    protected static final String JAVA_VM_NAME = "java.vm.name";
    protected static final String EMPTY = "";
    protected static final String HEADLESS_PROPERTY_NAME = "java.awt.headless";
    private static final String RESOURCE_CLASS = "org.python.util.install.TextConstants";
    private static ResourceBundle _textConstants = ResourceBundle.getBundle("org.python.util.install.TextConstants", Locale.getDefault());
    private static boolean _verbose = false;
    private static boolean _isAutotesting = false;

    public static void main(String[] args) {
        Installation.internalMain(args, null, null);
    }

    public static void driverMain(String[] args, Autotest autotest, Tunnel tunnel) {
        Installation.internalMain(args, autotest, tunnel);
    }

    protected static boolean isVerbose() {
        return _verbose;
    }

    protected static void setVerbose(boolean verbose) {
        _verbose = verbose;
    }

    protected static boolean isAutotesting() {
        return _isAutotesting;
    }

    protected static String getText(String key) {
        return _textConstants.getString(key);
    }

    protected static String getText(String key, String ... parameters) {
        return MessageFormat.format(_textConstants.getString(key), parameters);
    }

    protected static void setLanguage(Locale locale2) {
        _textConstants = ResourceBundle.getBundle(RESOURCE_CLASS, locale2);
    }

    public static boolean isValidOs() {
        String osName = System.getProperty(OS_NAME, EMPTY);
        String lowerOs = osName.toLowerCase();
        if (Installation.isWindows()) {
            return true;
        }
        if (lowerOs.indexOf("linux") >= 0) {
            return true;
        }
        if (lowerOs.indexOf("mac") >= 0) {
            return true;
        }
        return lowerOs.indexOf("unix") >= 0;
    }

    protected static boolean isValidJava(JavaVersionInfo javaVersionInfo) {
        String specificationVersion = javaVersionInfo.getSpecificationVersion();
        Installation.verboseOutput("specification version: '" + specificationVersion + "'");
        boolean valid = true;
        if (Installation.getJavaSpecificationVersion(specificationVersion) < 15) {
            valid = false;
        }
        return valid;
    }

    public static int getJavaSpecificationVersion(String specificationVersion) {
        String major = ALL;
        String minor = "0";
        StringTokenizer tokenizer = new StringTokenizer(specificationVersion, ".");
        if (tokenizer.hasMoreTokens()) {
            major = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            minor = tokenizer.nextToken();
        }
        return Integer.valueOf(major.concat(minor));
    }

    public static boolean isWindows() {
        boolean isWindows = false;
        String osName = System.getProperty(OS_NAME, EMPTY);
        if (osName.toLowerCase().indexOf("windows") >= 0) {
            isWindows = true;
        }
        return isWindows;
    }

    protected static boolean isMacintosh() {
        boolean isMacintosh = false;
        String osName = System.getProperty(OS_NAME, EMPTY);
        if (osName.toLowerCase().indexOf("mac") >= 0) {
            isMacintosh = true;
        }
        return isMacintosh;
    }

    protected static boolean isGNUJava() {
        boolean isGNUJava = false;
        String javaVmName = System.getProperty(JAVA_VM_NAME, EMPTY);
        String lowerVmName = javaVmName.toLowerCase();
        if (lowerVmName.indexOf("gnu") >= 0 && lowerVmName.indexOf("libgcj") >= 0) {
            isGNUJava = true;
        }
        return isGNUJava;
    }

    protected static boolean isJDK141() {
        boolean isJDK141 = false;
        String javaVersion = System.getProperty("java.version", EMPTY);
        if (javaVersion.toLowerCase().startsWith("1.4.1")) {
            isJDK141 = true;
        }
        return isJDK141;
    }

    protected static JavaVersionInfo getExternalJavaVersion(JavaHomeHandler javaHomeHandler) {
        JavaVersionInfo versionInfo;
        block7: {
            versionInfo = new JavaVersionInfo();
            if (javaHomeHandler.isValidHome()) {
                try {
                    ConsoleInstaller.message(Installation.getText("C_CHECK_JAVA_VERSION"));
                    File tempFile = File.createTempFile("jython_installation", ".properties");
                    if (tempFile.exists() && tempFile.canWrite()) {
                        String[] command = new String[]{javaHomeHandler.getExecutableName(), "-cp", System.getProperty("java.class.path"), JavaVersionTester.class.getName(), tempFile.getAbsolutePath()};
                        Installation.verboseOutput("executing: " + command[0] + " " + command[1] + " " + command[2] + " " + command[3] + " " + command[4]);
                        ChildProcess childProcess = new ChildProcess(command, 10000L);
                        childProcess.setDebug(Installation.isVerbose());
                        int errorCode = childProcess.run();
                        if (errorCode != 0) {
                            versionInfo.setErrorCode(errorCode);
                            versionInfo.setReason(Installation.getText("C_NO_VALID_JAVA", javaHomeHandler.toString()));
                        } else {
                            Properties tempProperties = new Properties();
                            tempProperties.load(new FileInputStream(tempFile));
                            Installation.fillJavaVersionInfo(versionInfo, tempProperties);
                        }
                        break block7;
                    }
                    versionInfo.setErrorCode(1);
                    versionInfo.setReason(Installation.getText("C_UNABLE_CREATE_TMPFILE", tempFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    versionInfo.setErrorCode(1);
                    versionInfo.setReason(Installation.getText("C_NO_VALID_JAVA", javaHomeHandler.toString()));
                }
            } else {
                versionInfo.setErrorCode(1);
                versionInfo.setReason(Installation.getText("C_NO_VALID_JAVA", javaHomeHandler.toString()));
            }
        }
        return versionInfo;
    }

    public static JavaVersionInfo getDefaultJavaVersion() {
        JavaVersionInfo versionInfo = new JavaVersionInfo();
        String executableName = "java";
        try {
            File tempFile = File.createTempFile("jython_installation", ".properties");
            if (tempFile.exists() && tempFile.canWrite()) {
                String[] command = new String[]{executableName, "-cp", System.getProperty("java.class.path"), JavaVersionTester.class.getName(), tempFile.getAbsolutePath()};
                ChildProcess childProcess = new ChildProcess(command, 10000L);
                childProcess.setDebug(false);
                int errorCode = childProcess.run();
                if (errorCode != 0) {
                    versionInfo.setErrorCode(errorCode);
                    versionInfo.setReason(Installation.getText("C_NO_VALID_JAVA", executableName));
                } else {
                    Properties tempProperties = new Properties();
                    tempProperties.load(new FileInputStream(tempFile));
                    Installation.fillJavaVersionInfo(versionInfo, tempProperties);
                }
            } else {
                versionInfo.setErrorCode(1);
                versionInfo.setReason(Installation.getText("C_UNABLE_CREATE_TMPFILE", tempFile.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            versionInfo.setErrorCode(1);
            versionInfo.setReason(Installation.getText("C_NO_VALID_JAVA", executableName));
        }
        return versionInfo;
    }

    protected static void fillJavaVersionInfo(JavaVersionInfo versionInfo, Properties properties) {
        versionInfo.setVersion(properties.getProperty("java.version"));
        versionInfo.setSpecificationVersion(properties.getProperty("java.specification.version"));
        versionInfo.setVendor(properties.getProperty("java.vendor"));
    }

    public static boolean isGuiAllowed() {
        Installation.verboseOutput("checking gui availability");
        if (Boolean.getBoolean(HEADLESS_PROPERTY_NAME)) {
            Installation.verboseOutput("java.awt.headless is true");
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            Installation.verboseOutput("GraphicsEnvironment is headless");
            return false;
        }
        try {
            Installation.verboseOutput("trying to get the GraphicsEnvironment");
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            Installation.verboseOutput("got the GraphicsEnvironment!");
            return true;
        }
        catch (Throwable t) {
            Installation.verboseOutput("got the following exception:");
            Installation.verboseOutput(t);
            return false;
        }
    }

    private static boolean useGui(InstallerCommandLine commandLine) {
        if (commandLine.hasConsoleOption() || commandLine.hasSilentOption()) {
            return false;
        }
        return Installation.isGuiAllowed();
    }

    private static void internalMain(String[] args, Autotest autotest, Tunnel tunnel) {
        try {
            Installation.setVerbose(InstallerCommandLine.hasVerboseOptionInArgs(args));
            Installation.dumpSystemProperties();
            Installation.verboseOutput("reading jar info");
            JarInfo jarInfo = new JarInfo();
            InstallerCommandLine commandLine = new InstallerCommandLine(jarInfo);
            if (!commandLine.setArgs(args) || commandLine.hasHelpOption()) {
                commandLine.printHelp();
                System.exit(1);
            } else {
                if (commandLine.hasAutotestOption()) {
                    Installation.verboseOutput("running autotests");
                    _isAutotesting = true;
                    InstallationDriver autotestDriver = new InstallationDriver(commandLine);
                    autotestDriver.drive();
                    _isAutotesting = false;
                    ConsoleInstaller.message("\ncongratulations - autotests complete !");
                    System.exit(0);
                }
                if (!Installation.useGui(commandLine)) {
                    Installation.verboseOutput("using the console installer");
                    ConsoleInstaller consoleInstaller = new ConsoleInstaller(commandLine, jarInfo);
                    consoleInstaller.setTunnel(tunnel);
                    consoleInstaller.install();
                    if (!Installation.isAutotesting()) {
                        System.exit(0);
                    }
                } else {
                    Installation.verboseOutput("using the gui installer");
                    new FrameInstaller(commandLine, jarInfo, autotest);
                }
            }
        }
        catch (InstallationCancelledException ice) {
            ConsoleInstaller.message(Installation.getText("INSTALLATION_CANCELLED"));
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static void dumpSystemProperties() throws IOException {
        if (Installation.isVerbose()) {
            Enumeration<?> names = System.getProperties().propertyNames();
            StringBuilder contents = new StringBuilder(400);
            contents.append("Properties at the beginning of the Jython installation:\n\n");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = System.getProperty(name, EMPTY);
                contents.append(name);
                contents.append('=');
                contents.append(value);
                contents.append("\n");
            }
            File output = File.createTempFile("System", ".properties");
            FileHelper.write(output, contents.toString());
            ConsoleInstaller.message("system properties dumped to " + output.getAbsolutePath());
        }
    }

    private static void verboseOutput(String message2) {
        if (Installation.isVerbose()) {
            ConsoleInstaller.message(message2);
        }
    }

    private static void verboseOutput(Throwable t) {
        if (Installation.isVerbose()) {
            t.printStackTrace();
        }
    }

    public static class JavaVersionInfo {
        private String _version = "";
        private String _specificationVersion = "";
        private String _vendor;
        private int _errorCode = 0;
        private String _reason = "";

        protected JavaVersionInfo() {
        }

        protected void setVersion(String version2) {
            this._version = version2;
        }

        protected void setSpecificationVersion(String specificationVersion) {
            this._specificationVersion = specificationVersion;
        }

        protected void setVendor(String vendor) {
            this._vendor = vendor;
        }

        protected void setErrorCode(int errorCode) {
            this._errorCode = errorCode;
        }

        protected void setReason(String reason) {
            this._reason = reason;
        }

        protected String getVersion() {
            return this._version;
        }

        public String getSpecificationVersion() {
            return this._specificationVersion;
        }

        protected String getVendor() {
            return this._vendor;
        }

        public int getErrorCode() {
            return this._errorCode;
        }

        protected String getReason() {
            return this._reason;
        }
    }

    protected static class JavaFilenameFilter
    implements FilenameFilter {
        protected JavaFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith("java");
        }
    }
}

