/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.python.util.install.Installation;
import org.python.util.install.InstallationCancelledException;
import org.python.util.install.InstallationType;
import org.python.util.install.InstallerCommandLine;
import org.python.util.install.InstallerException;
import org.python.util.install.JarInfo;
import org.python.util.install.JarInstaller;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.ProgressListener;
import org.python.util.install.TextKeys;
import org.python.util.install.driver.Tunnel;

public class ConsoleInstaller
implements ProgressListener,
TextKeys {
    public static final String CURRENT_JRE = "=";
    private static final String _CANCEL = "c";
    private static final String _PROMPT = ">>>";
    private static final String _BEGIN_ANSWERS = "[";
    private static final String _END_ANSWERS = "]";
    private InstallerCommandLine _commandLine;
    private JarInstaller _jarInstaller;
    private JarInfo _jarInfo;
    private Tunnel _tunnel;

    public ConsoleInstaller(InstallerCommandLine commandLine, JarInfo jarInfo) {
        this._commandLine = commandLine;
        this._jarInfo = jarInfo;
        this._jarInstaller = new JarInstaller(this, jarInfo);
    }

    public void setTunnel(Tunnel tunnel) {
        this._tunnel = tunnel;
    }

    public void install() {
        File targetDirectory = null;
        JavaHomeHandler javaHomeHandler = null;
        if (this._commandLine.hasConsoleOption()) {
            this.welcome();
            this.selectLanguage();
            this.acceptLicense();
            InstallationType installationType = this.selectInstallationType();
            targetDirectory = this.determineTargetDirectory();
            javaHomeHandler = this.checkVersion(this.determineJavaHome());
            this.promptForCopying(targetDirectory, installationType, javaHomeHandler);
            this._jarInstaller.inflate(targetDirectory, installationType, javaHomeHandler);
            this.showReadme(targetDirectory);
            this.success(targetDirectory);
        } else if (this._commandLine.hasSilentOption()) {
            ConsoleInstaller.message(this.getText("C_SILENT_INSTALLATION"));
            targetDirectory = this._commandLine.getTargetDirectory();
            this.checkTargetDirectorySilent(targetDirectory);
            javaHomeHandler = this.checkVersionSilent(this._commandLine.getJavaHomeHandler());
            this._jarInstaller.inflate(targetDirectory, this._commandLine.getInstallationType(), javaHomeHandler);
            this.success(targetDirectory);
        }
    }

    protected static final void message(String message2) {
        System.out.println(message2);
    }

    private void welcome() {
        ConsoleInstaller.message(this.getText("C_WELCOME_TO_JYTHON"));
        ConsoleInstaller.message(this.getText("C_VERSION_INFO", this._jarInfo.getVersion()));
        ConsoleInstaller.message(this.getText("C_AT_ANY_TIME_CANCEL", _CANCEL));
    }

    private String question(String question) {
        return this.question(question, null, false, null);
    }

    private String question(String question, boolean answerRequired) {
        return this.question(question, null, answerRequired, null);
    }

    private String question(String question, List<String> answers, String defaultAnswer) {
        return this.question(question, answers, true, defaultAnswer);
    }

    private String question(String question, List<String> answers, boolean answerRequired, String defaultAnswer) {
        try {
            if (answers != null && answers.size() > 0) {
                question = question + " " + _BEGIN_ANSWERS;
                Iterator<String> answersAsIterator = answers.iterator();
                while (answersAsIterator.hasNext()) {
                    String possibleAnswer;
                    if (!question.endsWith(_BEGIN_ANSWERS)) {
                        question = question + "/";
                    }
                    if ((possibleAnswer = answersAsIterator.next()).equalsIgnoreCase(defaultAnswer)) {
                        if (Character.isDigit(possibleAnswer.charAt(0))) {
                            question = question.concat(" ").concat(possibleAnswer).concat(" ");
                            continue;
                        }
                        question = question + possibleAnswer.toUpperCase();
                        continue;
                    }
                    question = question + possibleAnswer;
                }
                question = question + _END_ANSWERS;
            }
            question = question + " " + _PROMPT + " ";
            boolean match = false;
            String answer = "";
            while (!match && !_CANCEL.equalsIgnoreCase(answer)) {
                System.out.print(question);
                answer = this.readLine();
                if ("".equals(answer) && answerRequired) {
                    if (defaultAnswer == null) continue;
                    match = true;
                    answer = defaultAnswer;
                    continue;
                }
                if (answers != null && answers.size() > 0) {
                    Iterator<String> answersAsIterator = answers.iterator();
                    while (answersAsIterator.hasNext()) {
                        if (!answer.equalsIgnoreCase(answersAsIterator.next())) continue;
                        match = true;
                    }
                } else {
                    match = true;
                }
                if (match || _CANCEL.equalsIgnoreCase(answer)) continue;
                ConsoleInstaller.message(this.getText("C_INVALID_ANSWER", answer));
            }
            if (_CANCEL.equalsIgnoreCase(answer)) {
                throw new InstallationCancelledException();
            }
            return answer;
        }
        catch (IOException ioe) {
            throw new InstallerException(ioe);
        }
    }

    private String readLine() throws IOException {
        InputStream inputStream;
        String line = "";
        if (this._tunnel == null) {
            inputStream = System.in;
        } else {
            inputStream = this._tunnel.getAnswerReceiverStream();
            this._tunnel.getQuestionSenderStream().write("\n".getBytes());
            this._tunnel.getQuestionSenderStream().flush();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        line = reader.readLine();
        return line;
    }

    private void selectLanguage() {
        ArrayList<String> availableLanguages = new ArrayList<String>(2);
        availableLanguages.add(this.getText("C_ENGLISH"));
        availableLanguages.add(this.getText("C_GERMAN"));
        ArrayList<String> answers = new ArrayList<String>(availableLanguages.size());
        String languages = "";
        String defaultAnswer = null;
        for (String language : availableLanguages) {
            String possibleAnswer = language.substring(0, 1);
            if (defaultAnswer == null) {
                defaultAnswer = possibleAnswer;
            }
            languages = languages + language + ", ";
            answers.add(possibleAnswer.toLowerCase());
        }
        languages = languages.substring(0, languages.length() - 2);
        ConsoleInstaller.message(this.getText("C_AVAILABLE_LANGUAGES", languages));
        String answer = this.question(this.getText("C_SELECT_LANGUAGE"), answers, defaultAnswer);
        if (answer.equalsIgnoreCase((String)answers.get(1))) {
            Installation.setLanguage(Locale.GERMAN);
        } else {
            Installation.setLanguage(Locale.ENGLISH);
        }
    }

    private InstallationType selectInstallationType() {
        InstallationType installationType = new InstallationType();
        String no = this.getText("C_NO");
        String yes = this.getText("C_YES");
        ConsoleInstaller.message(this.getText("C_INSTALL_TYPES"));
        ConsoleInstaller.message("  1. " + this.getText("C_ALL"));
        ConsoleInstaller.message("  2. " + this.getText("C_STANDARD"));
        ConsoleInstaller.message("  3. " + this.getText("C_MINIMUM"));
        ConsoleInstaller.message("  9. " + this.getText("C_STANDALONE"));
        String answer = this.question(this.getText("C_SELECT_INSTALL_TYPE"), this.getTypeAnswers(), "1");
        if ("1".equals(answer)) {
            installationType.setAll();
        } else if ("2".equals(answer)) {
            installationType.setStandard();
        } else if ("3".equals(answer)) {
            installationType.setMinimum();
        } else if ("9".equals(answer)) {
            installationType.setStandalone();
        }
        if (!installationType.isStandalone()) {
            if (!installationType.isAll() && yes.equals(answer = this.question(this.getText("C_INCLUDE"), this.getYNAnswers(), no))) {
                do {
                    if ("mod".equals(answer = this.question(this.getText("C_INEXCLUDE_PARTS", no), this.getInExcludeAnswers(), no))) {
                        installationType.addLibraryModules();
                    } else if ("demo".equals(answer)) {
                        installationType.addDemosAndExamples();
                    } else if ("doc".equals(answer)) {
                        installationType.addDocumentation();
                    } else if ("src".equals(answer)) {
                        installationType.addSources();
                    } else if ("ensurepip".equals(answer)) {
                        installationType.addEnsurepip();
                    }
                    if (no.equals(answer)) continue;
                    ConsoleInstaller.message(this.getText("C_SCHEDULED", answer));
                } while (!no.equals(answer));
            }
            if (!installationType.isMinimum() && yes.equals(answer = this.question(this.getText("C_EXCLUDE"), this.getYNAnswers(), no))) {
                do {
                    if ("mod".equals(answer = this.question(this.getText("C_INEXCLUDE_PARTS", no), this.getInExcludeAnswers(), no))) {
                        installationType.removeLibraryModules();
                    } else if ("demo".equals(answer)) {
                        installationType.removeDemosAndExamples();
                    } else if ("doc".equals(answer)) {
                        installationType.removeDocumentation();
                    } else if ("src".equals(answer)) {
                        installationType.removeSources();
                    } else if ("ensurepip".equals(answer)) {
                        installationType.removeEnsurepip();
                    }
                    if (no.equals(answer)) continue;
                    ConsoleInstaller.message(this.getText("C_UNSCHEDULED", answer));
                } while (!no.equals(answer));
            }
        }
        return installationType;
    }

    private JavaHomeHandler checkVersion(JavaHomeHandler javaHomeHandler) {
        JavaInfo javaInfo = this.verifyTargetJava(javaHomeHandler);
        ConsoleInstaller.message(this.getText("C_JAVA_VERSION", javaInfo.getJavaVersionInfo().getVendor(), javaInfo.getJavaVersionInfo().getVersion()));
        if (!Installation.isValidJava(javaInfo.getJavaVersionInfo())) {
            ConsoleInstaller.message(this.getText("C_UNSUPPORTED_JAVA"));
            this.question(this.getText("C_PROCEED_ANYWAY"));
        }
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        ConsoleInstaller.message(this.getText("C_OS_VERSION", osName, osVersion));
        if (!Installation.isValidOs()) {
            ConsoleInstaller.message(this.getText("C_UNSUPPORTED_OS"));
            this.question(this.getText("C_PROCEED_ANYWAY"));
        }
        return javaInfo.getJavaHomeHandler();
    }

    private JavaHomeHandler checkVersionSilent(JavaHomeHandler javaHomeHandler) {
        JavaInfo javaInfo = this.verifyTargetJava(javaHomeHandler);
        if (!Installation.isValidJava(javaInfo.getJavaVersionInfo())) {
            ConsoleInstaller.message(this.getText("C_UNSUPPORTED_JAVA"));
        }
        if (!Installation.isValidOs()) {
            ConsoleInstaller.message(this.getText("C_UNSUPPORTED_OS"));
        }
        return javaInfo.getJavaHomeHandler();
    }

    private JavaInfo verifyTargetJava(JavaHomeHandler javaHomeHandler) {
        Installation.JavaVersionInfo javaVersionInfo = new Installation.JavaVersionInfo();
        Installation.fillJavaVersionInfo(javaVersionInfo, System.getProperties());
        if (javaHomeHandler.isDeviation() && (javaVersionInfo = Installation.getExternalJavaVersion(javaHomeHandler)).getErrorCode() != 0) {
            ConsoleInstaller.message(this.getText("C_TO_CURRENT_JAVA", javaVersionInfo.getReason()));
            javaHomeHandler = new JavaHomeHandler();
        }
        JavaInfo javaInfo = new JavaInfo();
        javaInfo.setJavaHomeHandler(javaHomeHandler);
        javaInfo.setJavaVersionInfo(javaVersionInfo);
        return javaInfo;
    }

    private void acceptLicense() {
        String accept;
        String no = this.getText("C_NO");
        String yes = this.getText("C_YES");
        String read = this.question(this.getText("C_READ_LICENSE"), this.getYNAnswers(), no);
        if (read.equalsIgnoreCase(this.getText("C_YES"))) {
            String licenseText = "n/a";
            try {
                licenseText = this._jarInfo.getLicenseText();
                ConsoleInstaller.message(licenseText);
            }
            catch (IOException ioe) {
                throw new InstallerException(ioe);
            }
        }
        if (!(accept = this.question(this.getText("C_ACCEPT"), this.getYNAnswers(), yes)).equalsIgnoreCase(this.getText("C_YES"))) {
            throw new InstallationCancelledException();
        }
    }

    private File determineTargetDirectory() {
        String no = this.getText("C_NO");
        String yes = this.getText("C_YES");
        File targetDirectory = null;
        try {
            do {
                if ((targetDirectory = new File(this.question(this.getText("C_ENTER_TARGET_DIRECTORY"), true))).exists()) {
                    String clear;
                    String overwrite;
                    if (!targetDirectory.isDirectory()) {
                        ConsoleInstaller.message(this.getText("C_NOT_A_DIRECTORY", targetDirectory.getCanonicalPath()));
                        continue;
                    }
                    if (targetDirectory.list().length <= 0 || !(overwrite = this.question(this.getText("C_OVERWRITE_DIRECTORY", targetDirectory.getCanonicalPath()), this.getYNAnswers(), no)).equalsIgnoreCase(this.getText("C_YES")) || !(clear = this.question(this.getText("C_CLEAR_DIRECTORY", targetDirectory.getCanonicalPath()), this.getYNAnswers(), yes)).equalsIgnoreCase(this.getText("C_YES"))) continue;
                    this.clearDirectory(targetDirectory);
                    continue;
                }
                String create = this.question(this.getText("C_CREATE_DIRECTORY", targetDirectory.getCanonicalPath()), this.getYNAnswers(), yes);
                if (!create.equalsIgnoreCase(this.getText("C_YES")) || targetDirectory.mkdirs()) continue;
                throw new InstallerException(this.getText("C_UNABLE_CREATE_DIRECTORY", targetDirectory.getCanonicalPath()));
            } while (!targetDirectory.exists() || !targetDirectory.isDirectory() || targetDirectory.list().length > 0);
        }
        catch (IOException ioe) {
            throw new InstallerException(ioe);
        }
        return targetDirectory;
    }

    private JavaHomeHandler determineJavaHome() {
        return new JavaHomeHandler();
    }

    private void checkTargetDirectorySilent(File targetDirectory) {
        try {
            if (!targetDirectory.exists()) {
                if (!targetDirectory.mkdirs()) {
                    throw new InstallerException(this.getText("C_UNABLE_CREATE_DIRECTORY", targetDirectory.getCanonicalPath()));
                }
            } else {
                if (!targetDirectory.isDirectory()) {
                    throw new InstallerException(this.getText("C_NOT_A_DIRECTORY", targetDirectory.getCanonicalPath()));
                }
                if (targetDirectory.list().length > 0) {
                    throw new InstallerException(this.getText("C_NON_EMPTY_TARGET_DIRECTORY", targetDirectory.getCanonicalPath()));
                }
            }
        }
        catch (IOException ioe) {
            throw new InstallerException(ioe);
        }
    }

    private void showReadme(File targetDirectory) {
        String no = this.getText("C_NO");
        String read = this.question(this.getText("C_READ_README"), this.getYNAnswers(), no);
        if (read.equalsIgnoreCase(this.getText("C_YES"))) {
            try {
                ConsoleInstaller.message(this._jarInfo.getReadmeText());
                this.question(this.getText("C_PROCEED"));
            }
            catch (IOException ioe) {
                throw new InstallerException(ioe);
            }
        }
    }

    private void clearDirectory(File targetDirectory) {
        File[] files = targetDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.clearDirectory(files[i]);
            }
            if (files[i].delete()) continue;
            throw new InstallerException(this.getText("C_UNABLE_TO_DELETE", files[i].getAbsolutePath()));
        }
    }

    private void promptForCopying(File targetDirectory, InstallationType installationType, JavaHomeHandler javaHomeHandler) {
        try {
            ConsoleInstaller.message(this.getText("C_SUMMARY"));
            if (installationType.isStandalone()) {
                ConsoleInstaller.message(" - standalone");
            } else {
                ConsoleInstaller.message("  - mod: " + installationType.installLibraryModules());
                ConsoleInstaller.message("  - demo: " + installationType.installDemosAndExamples());
                ConsoleInstaller.message("  - doc: " + installationType.installDocumentation());
                ConsoleInstaller.message("  - src: " + installationType.installSources());
                ConsoleInstaller.message("  - ensurepip: " + installationType.ensurepip());
                if (javaHomeHandler.isValidHome()) {
                    ConsoleInstaller.message("  - JRE: " + javaHomeHandler.getHome().getAbsolutePath());
                } else {
                    ConsoleInstaller.message("  - java");
                }
            }
            String proceed = this.question(this.getText("C_CONFIRM_TARGET", targetDirectory.getCanonicalPath()), this.getYNAnswers(), this.getText("C_YES"));
            if (!proceed.equalsIgnoreCase(this.getText("C_YES"))) {
                throw new InstallationCancelledException();
            }
        }
        catch (IOException ioe) {
            throw new InstallerException(ioe);
        }
    }

    private void success(File targetDirectory) {
        try {
            ConsoleInstaller.message(this.getText("C_CONGRATULATIONS") + " " + this.getText("C_SUCCESS", this._jarInfo.getVersion(), targetDirectory.getCanonicalPath()));
        }
        catch (IOException ioe) {
            throw new InstallerException(ioe);
        }
    }

    private List<String> getTypeAnswers() {
        ArrayList<String> answers = new ArrayList<String>(4);
        answers.add("1");
        answers.add("2");
        answers.add("3");
        answers.add("9");
        return answers;
    }

    private List<String> getYNAnswers() {
        ArrayList<String> answers = new ArrayList<String>(2);
        answers.add(this.getText("C_YES"));
        answers.add(this.getText("C_NO"));
        return answers;
    }

    private List<String> getInExcludeAnswers() {
        ArrayList<String> answers = new ArrayList<String>(5);
        answers.add("mod");
        answers.add("demo");
        answers.add("doc");
        answers.add("src");
        answers.add("ensurepip");
        answers.add(this.getText("C_NO"));
        return answers;
    }

    private void progressMessage(int percentage) {
        ConsoleInstaller.message(" " + percentage + " %");
    }

    private String getText(String textKey) {
        return Installation.getText(textKey);
    }

    private String getText(String textKey, String parameter0) {
        return Installation.getText(textKey, parameter0);
    }

    private String getText(String textKey, String parameter0, String parameter1) {
        return Installation.getText(textKey, parameter0, parameter1);
    }

    @Override
    public void progressChanged(int newPercentage) {
        this.progressMessage(newPercentage);
    }

    @Override
    public int getInterval() {
        return 10;
    }

    @Override
    public void progressFinished() {
        this.progressMessage(100);
    }

    @Override
    public void progressEntry(String entry) {
    }

    @Override
    public void progressStartScripts() {
        ConsoleInstaller.message(this.getText("C_GENERATE_START_SCRIPTS"));
    }

    @Override
    public void progressStandalone() {
        ConsoleInstaller.message(this.getText("C_PACKING_STANDALONE_JAR"));
    }

    @Override
    public void progressEnsurepip() {
        ConsoleInstaller.message(this.getText("C_ENSUREPIP"));
    }

    private static class JavaInfo {
        private Installation.JavaVersionInfo _javaVersionInfo;
        private JavaHomeHandler _javaHomeHandler;

        private JavaInfo() {
        }

        void setJavaHomeHandler(JavaHomeHandler javaHomeHandler) {
            this._javaHomeHandler = javaHomeHandler;
        }

        JavaHomeHandler getJavaHomeHandler() {
            return this._javaHomeHandler;
        }

        void setJavaVersionInfo(Installation.JavaVersionInfo javaVersionInfo) {
            this._javaVersionInfo = javaVersionInfo;
        }

        Installation.JavaVersionInfo getJavaVersionInfo() {
            return this._javaVersionInfo;
        }
    }
}

