/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.python.util.install.AbstractWizardHeader;
import org.python.util.install.AbstractWizardPage;
import org.python.util.install.ValidationListener;
import org.python.util.install.WizardEvent;
import org.python.util.install.WizardHeader;
import org.python.util.install.WizardListener;

public abstract class AbstractWizard
extends JDialog
implements ValidationListener {
    private AbstractWizardPage _activePage = null;
    private JPanel _buttonPanel;
    private JSeparator _buttonSeparator;
    private Action _cancelAction;
    private JButton _cancelButton;
    private CardLayout _cards;
    private JPanel _content;
    private WizardGlassPane _glassPane;
    private AbstractWizardHeader _header;
    private boolean _headerVisible = false;
    private ArrayList _listeners;
    private Action _nextAction;
    private JButton _nextButton;
    private ArrayList _pages;
    private Action _previousAction;
    private JButton _previousButton;

    public AbstractWizard() {
        this.initWindow();
        this.initActions();
        this.initComponents();
    }

    public AbstractWizard(Dialog parent) throws HeadlessException {
        super(parent);
        this.initWindow();
        this.initActions();
        this.initComponents();
    }

    public AbstractWizard(Frame parent) throws HeadlessException {
        super(parent);
        this.initWindow();
        this.initActions();
        this.initComponents();
    }

    public final void addPage(AbstractWizardPage page) {
        if (this._pages == null) {
            this._pages = new ArrayList();
        }
        if (page == null || this._pages.contains(page)) {
            return;
        }
        this._pages.add(page);
        page.setWizard(this);
        int number = this._pages.indexOf(page);
        this._content.add((Component)page, "page" + number);
    }

    public final void addWizardListener(WizardListener listener) {
        if (listener == null) {
            return;
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList(5);
        }
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    private void cancel() {
        this.fireCancelEvent();
        this.setVisible(false);
    }

    protected abstract boolean finish();

    private void fireCancelEvent() {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        WizardEvent event = new WizardEvent(this);
        for (WizardListener listener : this._listeners) {
            listener.wizardCancelled(event);
        }
    }

    private void fireFinishedEvent() {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        WizardEvent event = new WizardEvent(this);
        for (WizardListener listener : this._listeners) {
            listener.wizardFinished(event);
        }
    }

    private void fireNextEvent() {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        WizardEvent event = new WizardEvent(this);
        for (WizardListener listener : this._listeners) {
            listener.wizardNext(event);
        }
    }

    private void firePreviousEvent() {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        WizardEvent event = new WizardEvent(this);
        for (WizardListener listener : this._listeners) {
            listener.wizardPrevious(event);
        }
    }

    private void fireStartedEvent() {
        if (this._listeners == null || this._listeners.isEmpty()) {
            return;
        }
        WizardEvent event = new WizardEvent(this);
        for (WizardListener listener : this._listeners) {
            listener.wizardStarted(event);
        }
    }

    protected abstract String getCancelString();

    protected abstract String getFinishString();

    public AbstractWizardHeader getHeader() {
        return this._header;
    }

    protected abstract String getNextString();

    protected abstract String getPreviousString();

    public final void gotoNextPage() {
        this.next();
    }

    private void initActions() {
        this._nextAction = new AbstractAction(this.getNextString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.tryNext();
            }
        };
        this._previousAction = new AbstractAction(this.getPreviousString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.previous();
            }
        };
        this._cancelAction = new AbstractAction(this.getCancelString()){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizard.this.cancel();
            }
        };
    }

    private void initComponents() {
        this._pages = new ArrayList();
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this._header = new WizardHeader();
        this.getContentPane().add((Component)this._header, "North");
        this._content = new JPanel();
        this._cards = new CardLayout();
        this._content.setLayout(this._cards);
        this.getContentPane().add((Component)this._content, "Center");
        this._buttonPanel = new JPanel();
        this._buttonSeparator = new JSeparator();
        this._cancelButton = new JButton();
        this._previousButton = new JButton();
        this._nextButton = new JButton();
        this._cancelButton.setAction(this._cancelAction);
        this._previousButton.setAction(this._previousAction);
        this._nextButton.setAction(this._nextAction);
        this._buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        this._buttonPanel.add((Component)this._buttonSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._buttonPanel.add((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        this._buttonPanel.add((Component)this._previousButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        this._buttonPanel.add((Component)this._nextButton, gridBagConstraints);
        this.getContentPane().add((Component)this._buttonPanel, "South");
    }

    private void initWindow() {
        this._glassPane = new WizardGlassPane();
        this.setGlassPane(this._glassPane);
    }

    public final boolean isHeaderVisible() {
        return this._headerVisible;
    }

    public final void lock() {
        this._glassPane.setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void next() {
        if (this._activePage == null) {
            return;
        }
        this._activePage.passivate();
        int activeIndex = this._pages.indexOf(this._activePage);
        int nextIndex = activeIndex + 1;
        if (nextIndex >= this._pages.size()) {
            this.tryFinish();
            return;
        }
        this._activePage = (AbstractWizardPage)this._pages.get(nextIndex);
        this.showActivePage();
        this.fireNextEvent();
    }

    private void previous() {
        if (this._activePage == null) {
            return;
        }
        this._activePage.passivate();
        int activeIndex = this._pages.indexOf(this._activePage);
        int previousIndex = activeIndex - 1;
        if (previousIndex < 0) {
            return;
        }
        this._activePage = (AbstractWizardPage)this._pages.get(previousIndex);
        this.showActivePage();
        this.firePreviousEvent();
    }

    public final void removeWizardListener(WizardListener listener) {
        if (listener == null || this._listeners == null || !this._listeners.contains(listener)) {
            return;
        }
        this._listeners.remove(listener);
    }

    public void setHeader(AbstractWizardHeader header2) {
        if (this._header != null) {
            this.getContentPane().remove(header2);
        }
        this._header = header2;
        if (this._header != null) {
            this.getContentPane().add((Component)header2, "North");
        }
    }

    public final void setHeaderVisible(boolean visible) {
        this._headerVisible = visible;
        if (this._header != null) {
            this._header.setVisible(visible);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.fireStartedEvent();
            if (this._pages.size() > 0) {
                this._activePage = (AbstractWizardPage)this._pages.get(0);
                this.showActivePage();
            }
        }
        super.setVisible(visible);
    }

    private void showActivePage() {
        if (this._activePage == null) {
            return;
        }
        int number = this._pages.indexOf(this._activePage);
        this._cards.show(this._content, "page" + number);
        if (this._header != null) {
            this._header.setTitle(this._activePage.getTitle());
            this._header.setDescription(this._activePage.getDescription());
            this._header.setIcon(this._activePage.getIcon());
        }
        if (number == 0) {
            this._previousButton.setVisible(false);
        } else {
            this._previousButton.setVisible(this._activePage.isPreviousVisible());
        }
        this._previousAction.putValue("Name", this.getPreviousString());
        this._cancelButton.setVisible(this._activePage.isCancelVisible());
        this._cancelAction.putValue("Name", this.getCancelString());
        this._nextButton.setVisible(this._activePage.isNextVisible());
        this._nextAction.putValue("Name", this.getNextString());
        if (number + 1 == this._pages.size()) {
            this._nextAction.putValue("Name", this.getFinishString());
        } else {
            this._nextAction.putValue("Name", this.getNextString());
        }
        if (this._nextButton.isVisible()) {
            this.getRootPane().setDefaultButton(this._nextButton);
            if (this._activePage.getFocusField() == null) {
                this._nextButton.grabFocus();
            }
        }
        this._activePage.doActivate();
    }

    private void tryFinish() {
        if (this.finish()) {
            this.setVisible(false);
            this.fireFinishedEvent();
        }
    }

    private void tryNext() {
        if (this._activePage == null) {
            return;
        }
        this._activePage.validateInput();
    }

    public final void unlock() {
        this._glassPane.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private class WizardGlassPane
    extends JPanel
    implements MouseListener,
    KeyListener {
        WizardGlassPane() {
            this.setOpaque(false);
            this.addMouseListener(this);
            this.addKeyListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

