/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install.driver;

import java.io.File;
import java.io.IOException;
import org.python.util.install.FileHelper;
import org.python.util.install.Installation;
import org.python.util.install.InstallationListener;
import org.python.util.install.InstallerCommandLine;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.driver.DriverException;
import org.python.util.install.driver.Verifier;

public abstract class Autotest
implements InstallationListener {
    private static final String _DIR_SUFFIX = "_dir";
    private static int _count = 0;
    private static File _rootDirectory = null;
    private static Installation.JavaVersionInfo _systemDefaultJavaVersion;
    private String _name;
    private File _targetDir;
    private JavaHomeHandler _javaHomeHandler;
    private boolean _verbose;
    private String[] _commandLineArgs;
    private Verifier _verifier;

    protected Autotest(InstallerCommandLine commandLine) throws IOException, DriverException {
        ++_count;
        this.buildName();
        if (_rootDirectory == null) {
            this.createRootDirectory();
        }
        this.createTargetDirectory();
        this.setCommandLineArgs(new String[0]);
        this._verbose = commandLine.hasVerboseOption();
        this._javaHomeHandler = commandLine.getJavaHomeHandler();
    }

    protected static File getRootDir() {
        return _rootDirectory;
    }

    protected File getTargetDir() {
        return this._targetDir;
    }

    protected String getName() {
        return this._name;
    }

    protected String[] getCommandLineArgs() {
        return this._commandLineArgs;
    }

    protected void setCommandLineArgs(String[] commandLineArgs) {
        this._commandLineArgs = commandLineArgs;
    }

    protected JavaHomeHandler getJavaHomeHandler() {
        return this._javaHomeHandler;
    }

    protected boolean isVerbose() {
        return this._verbose;
    }

    protected abstract String getNameSuffix();

    protected void assertTargetDirNotEmpty() throws DriverException {
        File targetDir = this.getTargetDir();
        if (targetDir != null && targetDir.exists() && targetDir.isDirectory() && targetDir.listFiles().length > 0) {
            return;
        }
        throw new DriverException("installation failed for " + targetDir.getAbsolutePath());
    }

    protected void addAdditionalArguments() {
        JavaHomeHandler javaHomeHandler;
        if (this.getTargetDir() != null) {
            this.addArgument("-d");
            this.addArgument(this.getTargetDir().getAbsolutePath());
        }
        if (this.isVerbose()) {
            this.addArgument("-v");
        }
        if ((javaHomeHandler = this.getJavaHomeHandler()).isDeviation() && javaHomeHandler.isValidHome()) {
            this.addArgument("-j");
            this.addArgument(javaHomeHandler.getHome().getAbsolutePath());
        }
    }

    protected void addArgument(String newArgument) {
        this.setCommandLineArgs(this.addArgument(newArgument, this.getCommandLineArgs()));
    }

    protected void setVerifier(Verifier verifier) {
        this._verifier = verifier;
        this._verifier.setTargetDir(this.getTargetDir());
    }

    protected Verifier getVerifier() {
        return this._verifier;
    }

    private void buildName() {
        StringBuilder b = new StringBuilder(24);
        if (_count <= 99) {
            b.append('0');
        }
        if (_count <= 9) {
            b.append('0');
        }
        b.append(_count);
        b.append(' ');
        if (this.canHandleExclamationMarks()) {
            b.append('!');
        }
        b.append(this.getNameSuffix());
        b.append('_');
        this._name = b.toString();
    }

    private String[] addArgument(String newArgument, String[] args) {
        String[] newArgs = new String[args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = args[i];
        }
        newArgs[args.length] = newArgument;
        return newArgs;
    }

    private void createRootDirectory() throws IOException, DriverException {
        File tmpFile = File.createTempFile("jython.autoinstall.root_", _DIR_SUFFIX);
        if (!FileHelper.createTempDirectory(tmpFile)) {
            throw new DriverException("unable to create root temporary directory");
        }
        _rootDirectory = tmpFile;
    }

    private void createTargetDirectory() throws IOException, DriverException {
        File tmpFile = File.createTempFile(this.getName(), _DIR_SUFFIX, _rootDirectory);
        if (!FileHelper.createTempDirectory(tmpFile)) {
            throw new DriverException("unable to create temporary target directory");
        }
        this._targetDir = tmpFile;
    }

    private boolean canHandleExclamationMarks() {
        String specificationVersion;
        boolean exclamation = false;
        if (!Installation.isWindows() && Installation.getJavaSpecificationVersion(specificationVersion = System.getProperty("java.specification.version", "")) > 15) {
            if (_systemDefaultJavaVersion == null) {
                _systemDefaultJavaVersion = Installation.getDefaultJavaVersion();
            }
            if (_systemDefaultJavaVersion.getErrorCode() == 0 && Installation.getJavaSpecificationVersion(specificationVersion = _systemDefaultJavaVersion.getSpecificationVersion()) > 15) {
                exclamation = true;
            }
        }
        return exclamation;
    }
}

