/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Properties;
import javax.swing.UIManager;
import org.python.util.install.Installation;
import org.python.util.install.InstallationType;
import org.python.util.install.InstallerCommandLine;
import org.python.util.install.JarInfo;
import org.python.util.install.JavaHomeHandler;
import org.python.util.install.Wizard;
import org.python.util.install.WizardEvent;
import org.python.util.install.WizardListener;
import org.python.util.install.driver.Autotest;

public class FrameInstaller {
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private static final String JAVA_VERSION_PROPERTY = "FrameInstaller.Version";
    private static final String JAVA_VENDOR_PROPERTY = "FrameInstaller.Vendor";
    private static final String JAVA_SPEC_VERSION_PROPERTY = "FrameInstaller.SpecVersion";
    private static final String INEX_MOD_PROPERTY = "FrameInstaller.mod";
    private static final String INEX_DEMO_PROPERTY = "FrameInstaller.demo";
    private static final String INEX_DOC_PROPERTY = "FrameInstaller.doc";
    private static final String INEX_SRC_PROPERTY = "FrameInstaller.src";
    private static final String INEX_ENSUREPIP_PROPERTY = "FrameInstaller.ensurepip";
    private static final String STANDALONE_PROPERTY = "FrameInstaller.standalone";
    private static Properties _properties = new Properties();
    private static JavaHomeHandler _javaHomeHandler;

    protected FrameInstaller(InstallerCommandLine commandLine, JarInfo jarInfo, Autotest autotest) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        _properties.clear();
        if (commandLine.hasDirectoryOption()) {
            FrameInstaller.setTargetDirectory(commandLine.getTargetDirectory().getAbsolutePath());
        }
        FrameInstaller.setJavaHomeHandler(commandLine.getJavaHomeHandler());
        FrameInstaller.initDefaultJava();
        Wizard wizard = new Wizard(jarInfo, autotest);
        wizard.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (!Installation.isAutotesting()) {
                    System.exit(0);
                }
            }
        });
        wizard.addWizardListener(new SimpleWizardListener());
        wizard.setVisible(true);
    }

    protected static void setProperty(String key, String value) {
        _properties.setProperty(key, value);
    }

    protected static String getProperty(String key) {
        return _properties.getProperty(key);
    }

    protected static String getProperty(String key, String defaultValue) {
        return _properties.getProperty(key, defaultValue);
    }

    protected static void setTargetDirectory(String targetDirectory) {
        FrameInstaller.setProperty("TARGET_DIRECTORY_PROPERTY", targetDirectory.trim());
    }

    protected static String getTargetDirectory() {
        return FrameInstaller.getProperty("TARGET_DIRECTORY_PROPERTY");
    }

    protected static void setJavaHomeHandler(JavaHomeHandler javaHomeHandler) {
        _javaHomeHandler = javaHomeHandler;
    }

    protected static JavaHomeHandler getJavaHomeHandler() {
        if (_javaHomeHandler == null) {
            _javaHomeHandler = new JavaHomeHandler();
        }
        return _javaHomeHandler;
    }

    protected static void setLanguage(Locale locale2) {
        FrameInstaller.setProperty("LANGUAGE_PROPERTY", locale2.toString());
        Installation.setLanguage(locale2);
    }

    protected static Locale getLanguage() {
        return new Locale(FrameInstaller.getProperty("LANGUAGE_PROPERTY"));
    }

    protected static InstallationType getInstallationType() {
        InstallationType installationType = new InstallationType();
        if (Boolean.valueOf(FrameInstaller.getProperty(STANDALONE_PROPERTY)).booleanValue()) {
            installationType.setStandalone();
        }
        if (Boolean.valueOf(FrameInstaller.getProperty(INEX_MOD_PROPERTY)).booleanValue()) {
            installationType.addLibraryModules();
        } else {
            installationType.removeLibraryModules();
        }
        if (Boolean.valueOf(FrameInstaller.getProperty(INEX_DEMO_PROPERTY)).booleanValue()) {
            installationType.addDemosAndExamples();
        } else {
            installationType.removeDemosAndExamples();
        }
        if (Boolean.valueOf(FrameInstaller.getProperty(INEX_DOC_PROPERTY)).booleanValue()) {
            installationType.addDocumentation();
        } else {
            installationType.removeDocumentation();
        }
        if (Boolean.valueOf(FrameInstaller.getProperty(INEX_SRC_PROPERTY)).booleanValue()) {
            installationType.addSources();
        } else {
            installationType.removeSources();
        }
        if (Boolean.valueOf(FrameInstaller.getProperty(INEX_ENSUREPIP_PROPERTY)).booleanValue()) {
            installationType.addEnsurepip();
        } else {
            installationType.removeEnsurepip();
        }
        return installationType;
    }

    protected static void setInstallationType(InstallationType installationType) {
        FrameInstaller.setProperty(STANDALONE_PROPERTY, Boolean.toString(installationType.isStandalone()));
        FrameInstaller.setProperty(INEX_MOD_PROPERTY, Boolean.toString(installationType.installLibraryModules()));
        FrameInstaller.setProperty(INEX_DEMO_PROPERTY, Boolean.toString(installationType.installDemosAndExamples()));
        FrameInstaller.setProperty(INEX_DOC_PROPERTY, Boolean.toString(installationType.installDocumentation()));
        FrameInstaller.setProperty(INEX_SRC_PROPERTY, Boolean.toString(installationType.installSources()));
        FrameInstaller.setProperty(INEX_ENSUREPIP_PROPERTY, Boolean.toString(installationType.ensurepip()));
    }

    protected static Installation.JavaVersionInfo getJavaVersionInfo() {
        Installation.JavaVersionInfo javaVersionInfo = new Installation.JavaVersionInfo();
        javaVersionInfo.setVersion(FrameInstaller.getProperty(JAVA_VERSION_PROPERTY));
        javaVersionInfo.setVendor(FrameInstaller.getProperty(JAVA_VENDOR_PROPERTY));
        javaVersionInfo.setSpecificationVersion(FrameInstaller.getProperty(JAVA_SPEC_VERSION_PROPERTY));
        return javaVersionInfo;
    }

    protected static void setJavaVersionInfo(Installation.JavaVersionInfo javaVersionInfo) {
        FrameInstaller.setProperty(JAVA_VERSION_PROPERTY, javaVersionInfo.getVersion());
        FrameInstaller.setProperty(JAVA_VENDOR_PROPERTY, javaVersionInfo.getVendor());
        FrameInstaller.setProperty(JAVA_SPEC_VERSION_PROPERTY, javaVersionInfo.getSpecificationVersion());
    }

    protected static void setAccept(boolean accept) {
        if (accept) {
            FrameInstaller.setProperty("ACCEPT_PROPERTY", TRUE);
        } else {
            FrameInstaller.setProperty("ACCEPT_PROPERTY", FALSE);
        }
    }

    protected static boolean isAccept() {
        return TRUE.equals(FrameInstaller.getProperty("ACCEPT_PROPERTY", FALSE));
    }

    protected static void initDefaultJava() {
        Installation.JavaVersionInfo javaVersionInfo = new Installation.JavaVersionInfo();
        Installation.fillJavaVersionInfo(javaVersionInfo, System.getProperties());
        FrameInstaller.setJavaVersionInfo(javaVersionInfo);
    }

    private class SimpleWizardListener
    implements WizardListener {
        private SimpleWizardListener() {
        }

        @Override
        public void wizardStarted(WizardEvent event) {
        }

        @Override
        public void wizardFinished(WizardEvent event) {
            if (!Installation.isAutotesting()) {
                System.exit(0);
            }
        }

        @Override
        public void wizardCancelled(WizardEvent event) {
            System.exit(1);
        }

        @Override
        public void wizardNext(WizardEvent event) {
        }

        @Override
        public void wizardPrevious(WizardEvent event) {
        }
    }
}

