/*
 * Decompiled with CFR 0.152.
 */
package org.python.util.install;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.python.util.install.AbstractWizard;
import org.python.util.install.AbstractWizardValidator;
import org.python.util.install.EmptyValidator;
import org.python.util.install.FileHelper;
import org.python.util.install.Installation;
import org.python.util.install.TextKeys;

public abstract class AbstractWizardPage
extends JPanel
implements TextKeys {
    private static final long serialVersionUID = -5233805023557214279L;
    private static final String _ICON_FILE_NAME = "jython_small_c.png";
    private static ImageIcon _imageIcon = null;
    private AbstractWizardValidator _validator = null;
    private AbstractWizard _wizard;

    public AbstractWizardPage() {
        this.setValidator(null);
    }

    protected abstract void activate();

    protected abstract void beforeValidate();

    final void doActivate() {
        if (this.getFocusField() != null) {
            this.getFocusField().grabFocus();
        }
        this.activate();
    }

    protected abstract String getDescription();

    protected abstract JComponent getFocusField();

    protected ImageIcon getIcon() {
        URL iconURL;
        if (_imageIcon == null && (iconURL = FileHelper.getRelativeURL(this.getClass(), _ICON_FILE_NAME)) != null) {
            _imageIcon = new ImageIcon(iconURL);
        }
        return _imageIcon;
    }

    protected abstract String getTitle();

    public final AbstractWizard getWizard() {
        return this._wizard;
    }

    protected abstract boolean isCancelVisible();

    protected abstract boolean isNextVisible();

    protected abstract boolean isPreviousVisible();

    protected abstract void passivate();

    public final void setValidator(AbstractWizardValidator validator) {
        this._validator = validator == null ? new EmptyValidator() : validator;
        this._validator.setWizardPage(this);
        this._validator.addValidationListener(this._wizard);
    }

    final void setWizard(AbstractWizard wizard) {
        this._wizard = wizard;
        this._validator.addValidationListener(wizard);
    }

    final void validateInput() {
        this.beforeValidate();
        if (this._validator == null) {
            return;
        }
        this._validator.start();
    }

    protected GridBagConstraints newGridBagConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        return gridBagConstraints;
    }

    final String getText(String textKey) {
        return Installation.getText(textKey);
    }

    final String getText(String textKey, String parameter0) {
        return Installation.getText(textKey, parameter0);
    }

    final String getText(String textKey, String parameter0, String parameter1) {
        return Installation.getText(textKey, parameter0, parameter1);
    }
}

