/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront;

import io.micrometer.wavefront.WavefrontConfig;
import org.springframework.boot.actuate.autoconfigure.metrics.export.properties.PushRegistryPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontProperties;

public class WavefrontPropertiesConfigAdapter
extends PushRegistryPropertiesConfigAdapter<WavefrontProperties.Metrics.Export>
implements WavefrontConfig {
    private final WavefrontProperties properties;

    public WavefrontPropertiesConfigAdapter(WavefrontProperties properties) {
        super(properties.getMetrics().getExport());
        this.properties = properties;
    }

    public String prefix() {
        return "management.wavefront.metrics.export";
    }

    public String uri() {
        return this.properties.getEffectiveUri().toString();
    }

    public String source() {
        return this.properties.getSourceOrDefault();
    }

    @Override
    public int batchSize() {
        return this.properties.getSender().getBatchSize();
    }

    public String apiToken() {
        return this.properties.getApiTokenOrThrow();
    }

    public String globalPrefix() {
        return this.get(WavefrontProperties.Metrics.Export::getGlobalPrefix, () -> super.globalPrefix());
    }

    public boolean reportMinuteDistribution() {
        return this.get(WavefrontProperties.Metrics.Export::isReportMinuteDistribution, () -> super.reportMinuteDistribution());
    }

    public boolean reportHourDistribution() {
        return this.get(WavefrontProperties.Metrics.Export::isReportHourDistribution, () -> super.reportHourDistribution());
    }

    public boolean reportDayDistribution() {
        return this.get(WavefrontProperties.Metrics.Export::isReportDayDistribution, () -> super.reportDayDistribution());
    }
}

