/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.SmartClassLoader;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class StandardTypeLocator
implements TypeLocator {
    @Nullable
    private final ClassLoader classLoader;
    private final List<String> importPrefixes = new ArrayList<String>(1);
    private final Map<String, Class<?>> typeCache = new ConcurrentHashMap();

    public StandardTypeLocator() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public StandardTypeLocator(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.registerImport("java.lang");
    }

    public void registerImport(String prefix) {
        this.importPrefixes.add(prefix);
    }

    public void removeImport(String prefix) {
        this.importPrefixes.remove(prefix);
    }

    public List<String> getImportPrefixes() {
        return Collections.unmodifiableList(this.importPrefixes);
    }

    @Override
    public Class<?> findType(String typeName) throws EvaluationException {
        SmartClassLoader scl;
        ClassLoader classLoader;
        Class<?> cachedType = this.typeCache.get(typeName);
        if (cachedType != null) {
            return cachedType;
        }
        Class<?> loadedType = this.loadType(typeName);
        if (!(loadedType == null || (classLoader = this.classLoader) instanceof SmartClassLoader && (scl = (SmartClassLoader)classLoader).isClassReloadable(loadedType))) {
            this.typeCache.put(typeName, loadedType);
            return loadedType;
        }
        throw new SpelEvaluationException(SpelMessage.TYPE_NOT_FOUND, typeName);
    }

    @Nullable
    private Class<?> loadType(String typeName) {
        try {
            return ClassUtils.forName((String)typeName, (ClassLoader)this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (String prefix : this.importPrefixes) {
                try {
                    String nameToLookup = prefix + "." + typeName;
                    return ClassUtils.forName((String)nameToLookup, (ClassLoader)this.classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            return null;
        }
    }
}

