/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.xebialabs.license.LicensePropertyType;
import java.util.HashMap;
import java.util.Map;

public enum LicenseProperty {
    LICENSE_VERSION("License version", LicensePropertyType.STRING),
    LICENSED_TO("Licensed to", LicensePropertyType.STRING),
    CONTACT("Contact", LicensePropertyType.STRING),
    PRODUCT("Product", LicensePropertyType.STRING),
    EXPIRES_AFTER("Expires after", LicensePropertyType.DATE),
    REPOSITORY_ID("Repository id", LicensePropertyType.STRING),
    MAX_NUMBER_OF_USERS("Maximum number of users", LicensePropertyType.STRING),
    MAX_NUMBER_OF_CIS("Licensed number of CIs", LicensePropertyType.MAP_STRING_INTEGER),
    LICENSED_PLUGINS("Licensed plugin", LicensePropertyType.LIST_OF_STRINGS),
    SUPPORT_POLICY("Support policy", LicensePropertyType.STRING),
    EDITION("Edition", LicensePropertyType.STRING),
    AWS_NONCE("Nonce", LicensePropertyType.STRING),
    AWS_PRODUCT_CODE("Product code", LicensePropertyType.STRING);

    private static Map<String, LicenseProperty> lookup;
    private final String name;
    private final LicensePropertyType type;

    private LicenseProperty(String name, LicensePropertyType type) {
        this.name = name;
        this.type = type;
    }

    public static LicenseProperty get(String name) {
        return lookup.get(name);
    }

    public static int getLongerNameLength() {
        int maxLength = 0;
        for (LicenseProperty licenseProperty : LicenseProperty.values()) {
            int length = licenseProperty.getName().length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public String getName() {
        return this.name;
    }

    public LicensePropertyType getType() {
        return this.type;
    }

    static {
        lookup = new HashMap<String, LicenseProperty>();
        for (LicenseProperty e : LicenseProperty.values()) {
            lookup.put(e.getName(), e);
        }
    }
}

