/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.common;

import com.jeta.forms.gui.common.FormSpecDefinition;
import com.jeta.open.registry.JETARegistry;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.rmi.server.UID;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class FormUtils {
    private static int m_count;
    static char[] letters;
    static final /* synthetic */ boolean $assertionsDisabled;

    static String _createUID() {
        int n;
        int n2;
        UID uID = new UID();
        StringBuffer stringBuffer = new StringBuffer(uID.toString());
        for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
            n = stringBuffer.charAt(n2);
            if (!(n < 48 || n > 57 && n < 65 || n > 90 && n < 97) && n <= 122) continue;
            int n3 = (int)(Math.random() * 26.0);
            stringBuffer.setCharAt(n2, letters[n3]);
        }
        n2 = stringBuffer.charAt(0);
        if (n2 < 65 || n2 > 90) {
            n = (int)(Math.random() * 26.0);
            stringBuffer.setCharAt(0, letters[n]);
        }
        return stringBuffer.toString();
    }

    public static String createUID() {
        if (FormUtils.isDebug()) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM d, yyyy - HH:mm:ss");
            return String.valueOf(++m_count) + "." + simpleDateFormat.format(calendar.getTime());
        }
        return FormUtils._createUID();
    }

    public static String fixPath(String string) {
        if (string == null) {
            return null;
        }
        char c = '/';
        if (File.separatorChar == '/') {
            c = '\\';
        }
        return string.replace(c, File.separatorChar);
    }

    public static String getReasonableSize(String string) {
        if ("DLU".equalsIgnoreCase(string)) {
            return "12";
        }
        if ("PX".equalsIgnoreCase(string)) {
            return "24";
        }
        if ("PT".equalsIgnoreCase(string)) {
            return "24";
        }
        if ("IN".equalsIgnoreCase(string)) {
            return "0.5";
        }
        if ("MM".equalsIgnoreCase(string)) {
            return "10";
        }
        if ("CM".equalsIgnoreCase(string)) {
            return "1";
        }
        FormUtils.safeAssert(false);
        return "10";
    }

    public static boolean isDesignMode() {
        Boolean bl = (Boolean)JETARegistry.lookup("AbeilleForms.designMode");
        return Boolean.TRUE.equals(bl);
    }

    public static boolean isDebug() {
        try {
            String string = System.getProperty("jeta1.debug");
            return string != null && string.equals("true");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isRuntime() {
        Boolean bl = (Boolean)JETARegistry.lookup("AbeilleForms.runTime");
        if (bl == null) {
            return true;
        }
        return Boolean.TRUE.equals(bl);
    }

    public static boolean isIntegralUnits(String string) {
        return "PX".equalsIgnoreCase(string) || "PT".equalsIgnoreCase(string) || "DLU".equalsIgnoreCase(string);
    }

    public static boolean isValidUnits(String string) {
        return "DLU".equalsIgnoreCase(string) || "PX".equalsIgnoreCase(string) || "PT".equalsIgnoreCase(string) || "IN".equalsIgnoreCase(string) || "MM".equalsIgnoreCase(string) || "CM".equalsIgnoreCase(string);
    }

    public static void setDesignMode(boolean bl) {
        JETARegistry.rebind("AbeilleForms.designMode", bl);
    }

    public static String fromAlignment(CellConstraints.Alignment alignment) {
        if (alignment == CellConstraints.DEFAULT) {
            return "DEFAULT";
        }
        if (alignment == CellConstraints.FILL) {
            return "FILL";
        }
        if (alignment == CellConstraints.TOP) {
            return "TOP";
        }
        if (alignment == CellConstraints.BOTTOM) {
            return "BOTTOM";
        }
        if (alignment == CellConstraints.CENTER) {
            return "CENTER";
        }
        if (alignment == CellConstraints.LEFT) {
            return "LEFT";
        }
        if (alignment == CellConstraints.RIGHT) {
            return "RIGHT";
        }
        return "DEFAULT";
    }

    public static CellConstraints.Alignment toAlignment(String string) {
        if (string.equalsIgnoreCase("DEFAULT")) {
            return CellConstraints.DEFAULT;
        }
        if (string.equalsIgnoreCase("FILL")) {
            return CellConstraints.FILL;
        }
        if (string.equalsIgnoreCase("TOP")) {
            return CellConstraints.TOP;
        }
        if (string.equalsIgnoreCase("BOTTOM")) {
            return CellConstraints.BOTTOM;
        }
        if (string.equalsIgnoreCase("CENTER")) {
            return CellConstraints.CENTER;
        }
        if (string.equalsIgnoreCase("LEFT")) {
            return CellConstraints.LEFT;
        }
        if (string.equalsIgnoreCase("RIGHT")) {
            return CellConstraints.RIGHT;
        }
        FormUtils.safeAssert(false);
        return CellConstraints.DEFAULT;
    }

    public static String toConstantSize(FormSpecDefinition formSpecDefinition) {
        StringBuffer stringBuffer = new StringBuffer();
        if (FormUtils.isIntegralUnits(formSpecDefinition.getConstantUnits())) {
            stringBuffer.append(Math.round(formSpecDefinition.getConstantSize()));
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("###0.0");
            String string = decimalFormat.format(formSpecDefinition.getConstantSize());
            string = string.replace(',', '.');
            stringBuffer.append(string);
        }
        stringBuffer.append(formSpecDefinition.getConstantUnits());
        return stringBuffer.toString();
    }

    public static String toEncodedString(FormSpecDefinition formSpecDefinition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(formSpecDefinition.getAlignment());
        stringBuffer.append(":");
        if ("CONSTANT".equalsIgnoreCase(formSpecDefinition.getSizeType())) {
            stringBuffer.append(FormUtils.toConstantSize(formSpecDefinition));
        } else if ("COMPONENT".equalsIgnoreCase(formSpecDefinition.getSizeType())) {
            stringBuffer.append(formSpecDefinition.getComponentSize());
        } else if ("BOUNDED".equalsIgnoreCase(formSpecDefinition.getSizeType())) {
            stringBuffer.append(formSpecDefinition.getBoundedSize());
            stringBuffer.append("(");
            stringBuffer.append(FormUtils.toConstantSize(formSpecDefinition));
            stringBuffer.append(";");
            stringBuffer.append(formSpecDefinition.getComponentSize());
            stringBuffer.append(")");
        } else {
            FormUtils.safeAssert(false);
        }
        stringBuffer.append(":");
        stringBuffer.append(formSpecDefinition.getResize());
        if ("GROW".equalsIgnoreCase(formSpecDefinition.getResize())) {
            stringBuffer.append("(");
            double d = formSpecDefinition.getResizeWeight();
            if (d > 1.0) {
                d = 1.0;
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            String string = decimalFormat.format(d);
            string = string.replace(',', '.');
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public static void updateLookAndFeel(Component component) {
        if (component == null) {
            return;
        }
        component.invalidate();
        component.validate();
        component.repaint();
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                FormUtils.updateLookAndFeel(componentArray[i]);
            }
        }
    }

    public static void safeAssert(boolean bl) {
        if (FormUtils.isDebug() && !$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !FormUtils.class.desiredAssertionStatus();
        m_count = 0;
        letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

